"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStepExecution = useStepExecution;
var _public = require("@kbn/kibana-react-plugin/public");
var _reactQuery = require("@kbn/react-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function useStepExecution(workflowExecutionId, stepExecutionId) {
  const {
    http
  } = (0, _public.useKibana)().services;
  return (0, _reactQuery.useQuery)({
    queryKey: ['stepExecution', workflowExecutionId, stepExecutionId],
    queryFn: async () => {
      const response = await http.get(`/api/workflowExecutions/${workflowExecutionId}/steps/${stepExecutionId}`);
      return response;
    },
    enabled: !!workflowExecutionId && !!stepExecutionId,
    staleTime: 5000,
    // Refresh every 5 seconds for real-time logs
    refetchInterval: 5000 // Auto-refresh logs
  });
}