"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CancelExecutionButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _workflows = require("@kbn/workflows");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_execution_detail/ui/cancel_execution_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CancelExecutionButton = ({
  execution
}) => {
  var _services$application;
  const {
    services
  } = (0, _public.useKibana)();
  const canCancelWorkflow = services === null || services === void 0 ? void 0 : (_services$application = services.application) === null || _services$application === void 0 ? void 0 : _services$application.capabilities.workflowsManagement.cancelWorkflowExecution;
  const shouldDisplay = (0, _react.useMemo)(() => {
    if (!execution || !canCancelWorkflow) {
      return false;
    }
    const isCancellableStatus = [_workflows.ExecutionStatus.RUNNING, _workflows.ExecutionStatus.WAITING, _workflows.ExecutionStatus.WAITING_FOR_INPUT, _workflows.ExecutionStatus.PENDING].includes(execution === null || execution === void 0 ? void 0 : execution.status);
    return isCancellableStatus;
  }, [execution, canCancelWorkflow]);
  const handleClick = async () => {
    try {
      var _services$http, _services$notificatio;
      await ((_services$http = services.http) === null || _services$http === void 0 ? void 0 : _services$http.post(`/api/workflowExecutions/${execution.id}/cancel`));
      (_services$notificatio = services.notifications) === null || _services$notificatio === void 0 ? void 0 : _services$notificatio.toasts.addSuccess({
        title: _i18n.i18n.translate('workflowsManagement.executionDetail.cancelButton.successNotificationTitle', {
          defaultMessage: 'Execution cancelled'
        })
      });
    } catch (error) {
      var _services$notificatio2, _services$notificatio3, _services$notificatio4;
      (_services$notificatio2 = services.notifications) === null || _services$notificatio2 === void 0 ? void 0 : (_services$notificatio3 = (_services$notificatio4 = _services$notificatio2.toasts).addError) === null || _services$notificatio3 === void 0 ? void 0 : _services$notificatio3.call(_services$notificatio4, error, {
        title: _i18n.i18n.translate('workflowsManagement.executionDetail.cancelButton.errorNotificationTitle', {
          defaultMessage: 'Error cancelling execution'
        })
      });
    }
  };
  return shouldDisplay && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    iconType: "cross",
    onClick: handleClick,
    "data-test-subj": "cancelExecutionButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "workflowsManagement.executionDetail.cancelButton",
    defaultMessage: "Cancel execution",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }));
};
exports.CancelExecutionButton = CancelExecutionButton;