"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutionDetail = void 0;
var _react = _interopRequireWildcard(require("react"));
var _workflows = require("@kbn/workflows");
var _yaml_utils = require("../../../../common/lib/yaml_utils");
var _use_workflow_execution = require("../../../entities/workflows/model/use_workflow_execution");
var _workflow_step_execution_list = require("./workflow_step_execution_list");
var _workflow_step_execution_flyout = require("./workflow_step_execution_flyout");
var _schema = require("../../../../common/schema");
var _workflow_execution_list_item = require("../../workflow_execution_list/ui/workflow_execution_list_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_execution_detail/ui/execution_detail.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExecutionDetail = ({
  workflowExecutionId,
  workflowYaml,
  setSelectedStepExecution,
  selectedStepExecutionId,
  setSelectedStep,
  onClose,
  onExecutionChange
}) => {
  var _workflowExecution$st2, _workflowExecution$du;
  const {
    data: workflowExecution,
    isLoading,
    error,
    refetch
  } = (0, _use_workflow_execution.useWorkflowExecution)(workflowExecutionId);
  const workflowDefinition = (0, _react.useMemo)(() => {
    if (workflowExecution) {
      return workflowExecution.workflowDefinition;
    }
    const parsingResult = (0, _yaml_utils.parseWorkflowYamlToJSON)(workflowYaml, (0, _schema.getWorkflowZodSchemaLoose)());
    if (!parsingResult.success) {
      return null;
    }
    return parsingResult.data;
  }, [workflowYaml, workflowExecution]);
  const closeFlyout = (0, _react.useCallback)(() => {
    setSelectedStepExecution(null);
  }, [setSelectedStepExecution]);
  (0, _react.useEffect)(() => {
    if (!workflowExecution) {
      return;
    }
    const intervalId = setInterval(() => {
      if (![_workflows.ExecutionStatus.COMPLETED, _workflows.ExecutionStatus.FAILED, _workflows.ExecutionStatus.CANCELLED, _workflows.ExecutionStatus.SKIPPED, _workflows.ExecutionStatus.TIMED_OUT].includes(workflowExecution.status)) {
        refetch();
        return;
      }
      clearInterval(intervalId);
    }, 500); // Refresh every 500ms

    return () => clearInterval(intervalId);
  }, [workflowExecution, refetch]);
  (0, _react.useEffect)(() => onExecutionChange === null || onExecutionChange === void 0 ? void 0 : onExecutionChange(workflowExecution), [workflowExecution, onExecutionChange]);
  const selectedStepExecutionFlyout = (0, _react.useMemo)(() => {
    var _workflowExecution$st;
    if (!(workflowExecution !== null && workflowExecution !== void 0 && (_workflowExecution$st = workflowExecution.stepExecutions) !== null && _workflowExecution$st !== void 0 && _workflowExecution$st.length)) {
      return null;
    }
    const selectedStepExecutionIndex = workflowExecution.stepExecutions.findIndex(step => step.id === selectedStepExecutionId);
    const selectedStepExecution = workflowExecution.stepExecutions[selectedStepExecutionIndex];
    if (!selectedStepExecution) {
      return null;
    }
    const goNext = selectedStepExecutionIndex < workflowExecution.stepExecutions.length - 1 ? () => {
      const nextStepExecutionIndex = (selectedStepExecutionIndex + 1) % workflowExecution.stepExecutions.length;
      const nextStepExecution = workflowExecution.stepExecutions[nextStepExecutionIndex];
      setSelectedStepExecution(nextStepExecution.id);
    } : undefined;
    const goPrevious = selectedStepExecutionIndex > 0 ? () => {
      const previousStepExecutionIndex = (selectedStepExecutionIndex - 1 + workflowExecution.stepExecutions.length) % workflowExecution.stepExecutions.length;
      const previousStepExecution = workflowExecution.stepExecutions[previousStepExecutionIndex];
      setSelectedStepExecution(previousStepExecution.id);
    } : undefined;
    return /*#__PURE__*/_react.default.createElement(_workflow_step_execution_flyout.WorkflowStepExecutionFlyout, {
      workflowExecutionId: workflowExecutionId,
      stepExecutionId: selectedStepExecution.id,
      stepExecution: selectedStepExecution,
      closeFlyout: closeFlyout,
      goNext: goNext,
      goPrevious: goPrevious,
      setSelectedStepId: setSelectedStep,
      isLoading: isLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 7
      }
    });
  }, [workflowExecution === null || workflowExecution === void 0 ? void 0 : workflowExecution.stepExecutions, workflowExecutionId, closeFlyout, setSelectedStep, selectedStepExecutionId, setSelectedStepExecution, isLoading]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedStepExecutionFlyout, /*#__PURE__*/_react.default.createElement(_workflow_execution_list_item.WorkflowExecutionListItem, {
    status: (_workflowExecution$st2 = workflowExecution === null || workflowExecution === void 0 ? void 0 : workflowExecution.status) !== null && _workflowExecution$st2 !== void 0 ? _workflowExecution$st2 : _workflows.ExecutionStatus.PENDING,
    startedAt: workflowExecution !== null && workflowExecution !== void 0 && workflowExecution.startedAt ? new Date(workflowExecution.startedAt) : null,
    duration: (_workflowExecution$du = workflowExecution === null || workflowExecution === void 0 ? void 0 : workflowExecution.duration) !== null && _workflowExecution$du !== void 0 ? _workflowExecution$du : null,
    selected: false,
    onClick: null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_workflow_step_execution_list.WorkflowStepExecutionList, {
    definition: workflowDefinition,
    execution: workflowExecution !== null && workflowExecution !== void 0 ? workflowExecution : null,
    isLoading: isLoading,
    error: error,
    onStepExecutionClick: stepExecutionId => {
      setSelectedStepExecution(stepExecutionId);
    },
    onClose: onClose || (() => {}),
    selectedId: selectedStepExecutionId !== null && selectedStepExecutionId !== void 0 ? selectedStepExecutionId : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }));
};
exports.ExecutionDetail = ExecutionDetail;