"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepExecutionTimeline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_formatted_date = require("../../../shared/ui/use_formatted_date");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_execution_detail/ui/step_execution_timeline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StepExecutionTimeline = ({
  logs,
  backgroundColor: _backgroundColor
}) => {
  const getFormattedDateTime = (0, _use_formatted_date.useGetFormattedDateTime)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const backgroundColor = _backgroundColor !== null && _backgroundColor !== void 0 ? _backgroundColor : euiTheme.colors.backgroundBasePlain;
  const items = (0, _react.useMemo)(() => {
    return logs.map(log => {
      let iconType = 'info';
      let icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: iconType,
        color: "subdued",
        css: {
          backgroundColor,
          borderRadius: euiTheme.border.radius.medium
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 9
        }
      });
      if (log.level === 'error') {
        iconType = 'error';
        icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: iconType,
          color: "danger",
          css: {
            backgroundColor,
            borderRadius: euiTheme.border.radius.medium
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 49,
            columnNumber: 11
          }
        });
      }
      if (log.level === 'warn') {
        iconType = 'warning';
        icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: iconType,
          color: "warning",
          css: {
            backgroundColor,
            borderRadius: euiTheme.border.radius.medium
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 62,
            columnNumber: 11
          }
        });
      }
      return {
        children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          direction: "column",
          gutterSize: "xs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 74,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 75,
            columnNumber: 13
          }
        }, getFormattedDateTime(new Date(log.timestamp))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 76,
            columnNumber: 13
          }
        }, log.message)),
        verticalAlign: 'top',
        icon
      };
    });
  }, [backgroundColor, euiTheme.border.radius.medium, getFormattedDateTime, logs]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTimeline, {
    items: items,
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 10
    }
  });
};
exports.StepExecutionTimeline = StepExecutionTimeline;