"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepExecutionTreeItemLabel = StepExecutionTreeItemLabel;
var _eui = require("@elastic/eui");
var _workflows = require("@kbn/workflows");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _format_duration = require("../../../shared/lib/format_duration");
var _translations = require("../../../shared/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_execution_detail/ui/step_execution_tree_item_label.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function StepExecutionTreeItemLabel({
  stepId,
  status,
  executionIndex,
  executionTimeMs,
  stepType,
  selected
}) {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const isDangerous = status && (0, _workflows.isDangerousStatus)(status);
  const isInactiveStatus = status === _workflows.ExecutionStatus.SKIPPED || status === _workflows.ExecutionStatus.PENDING;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "xs",
    justifyContent: "spaceBetween",
    responsive: false,
    css: styles.label,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: [styles.stepName, selected && styles.selectedStepName, isDangerous && styles.dangerousStepName, isInactiveStatus && styles.inactiveStepName],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, stepId, status === _workflows.ExecutionStatus.SKIPPED && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }, "(", (0, _translations.getStatusLabel)(status).toLowerCase(), ")"))), executionTimeMs && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: [styles.duration, isDangerous && styles.durationDangerous],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, executionTimeMs ? (0, _format_duration.formatDuration)(executionTimeMs) : null));
}
const componentStyles = {
  label: euiThemeContext => (0, _react2.css)({
    ...(0, _eui.euiFontSize)(euiThemeContext, 's')
  }),
  stepName: (0, _react2.css)({
    display: 'block',
    textOverflow: 'ellipsis',
    overflow: 'hidden',
    whiteSpace: 'nowrap',
    textAlign: 'left'
  }),
  selectedStepName: (0, _react2.css)({
    fontWeight: 'bold'
  }),
  dangerousStepName: ({
    euiTheme
  }) => (0, _react2.css)({
    color: euiTheme.colors.danger
  }),
  inactiveStepName: ({
    euiTheme
  }) => (0, _react2.css)({
    color: euiTheme.colors.textDisabled
  }),
  duration: ({
    euiTheme
  }) => (0, _react2.css)({
    color: euiTheme.colors.textDisabled,
    paddingRight: euiTheme.size.xs
  }),
  durationDangerous: ({
    euiTheme
  }) => (0, _react2.css)({
    color: euiTheme.colors.textDanger
  }),
  executionIndex: ({
    euiTheme
  }) => (0, _react2.css)({
    color: euiTheme.colors.textDisabled,
    display: 'inline-block',
    marginLeft: euiTheme.size.xs
  })
};