"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowStepExecutionFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _ui = require("../../../shared/ui");
var _step_execution_timeline_stateful = require("./step_execution_timeline_stateful");
var _step_execution_data_view = require("./step_execution_data_view");
var _use_formatted_date = require("../../../shared/ui/use_formatted_date");
var _format_duration = require("../../../shared/lib/format_duration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_execution_detail/ui/workflow_step_execution_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkflowStepExecutionFlyout = ({
  workflowExecutionId,
  stepExecutionId,
  stepExecution,
  closeFlyout,
  goNext,
  goPrevious,
  setSelectedStepId,
  isLoading = false
}) => {
  var _stepExecution$execut;
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const getFormattedDateTime = (0, _use_formatted_date.useGetFormattedDateTime)();
  const complicatedFlyoutTitleId = `Step ${stepExecution === null || stepExecution === void 0 ? void 0 : stepExecution.stepId} Execution Details`;
  const tabs = (0, _react.useMemo)(() => [{
    id: 'input',
    name: 'Input'
  }, {
    id: 'output',
    name: stepExecution !== null && stepExecution !== void 0 && stepExecution.output ? 'Output' : 'Error'
  }, {
    id: 'timeline',
    name: 'Timeline'
  }], [stepExecution]);
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(tabs[0].id);
  (0, _react.useEffect)(() => {
    setSelectedStepId((stepExecution === null || stepExecution === void 0 ? void 0 : stepExecution.stepId) || null);
    // reset the tab to the default one on step change
    setSelectedTabId(tabs[0].id);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [stepExecution === null || stepExecution === void 0 ? void 0 : stepExecution.stepId, tabs[0].id]);
  const renderInput = () => {
    return /*#__PURE__*/_react.default.createElement(_step_execution_data_view.StepExecutionDataView, {
      data: stepExecution === null || stepExecution === void 0 ? void 0 : stepExecution.input,
      title: "Step Input",
      "data-test-subj": "stepExecutionInputTable",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 7
      }
    });
  };
  const renderOutput = () => {
    if (stepExecution !== null && stepExecution !== void 0 && stepExecution.error) {
      return /*#__PURE__*/_react.default.createElement(_step_execution_data_view.StepExecutionDataView, {
        data: {
          error: stepExecution.error
        },
        title: "Step Error",
        "data-test-subj": "stepExecutionErrorTable",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_step_execution_data_view.StepExecutionDataView, {
      data: stepExecution === null || stepExecution === void 0 ? void 0 : stepExecution.output,
      title: "Step Output",
      "data-test-subj": "stepExecutionOutputTable",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 7
      }
    });
  };
  const renderTimeline = () => {
    return /*#__PURE__*/_react.default.createElement(_step_execution_timeline_stateful.StepExecutionTimelineStateful, {
      executionId: workflowExecutionId,
      stepExecutionId: stepExecutionId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 7
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: closeFlyout,
    hideCloseButton: true,
    "aria-labelledby": complicatedFlyoutTitleId,
    paddingSize: "none",
    type: "push",
    size: "s",
    pushMinBreakpoint: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    css: styles.flyoutHeader,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    iconType: "arrowLeft",
    "aria-label": "Previous step",
    onClick: goPrevious,
    disabled: !goPrevious,
    css: {
      cursor: goPrevious ? 'pointer' : 'not-allowed'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 15
    }
  }, "Previous"), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    iconType: "arrowRight",
    iconSide: "right",
    "aria-label": "Next step",
    onClick: goNext,
    disabled: !goNext,
    css: {
      cursor: goNext ? 'pointer' : 'not-allowed'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 15
    }
  }, "Next"))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    color: "text",
    onClick: closeFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.titleContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 9
    }
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 25
    }
  }), stepExecution && /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 15
    }
  }, getFormattedDateTime(new Date(stepExecution.startedAt))), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: complicatedFlyoutTitleId,
    css: styles.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 17
    }
  }, stepExecution.stepId))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 27
    }
  }), stepExecution && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    css: styles.stat,
    title: /*#__PURE__*/_react.default.createElement(_ui.StatusBadge, {
      textProps: {
        css: styles.statusBadge
      },
      status: stepExecution.status,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 25
      }
    }),
    titleSize: "xxs",
    textAlign: "left",
    isLoading: isLoading,
    description: "Status",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    css: styles.stat,
    title: (0, _format_duration.formatDuration)((_stepExecution$execut = stepExecution.executionTimeMs) !== null && _stepExecution$execut !== void 0 ? _stepExecution$execut : 0),
    titleSize: "xxs",
    textAlign: "left",
    isLoading: isLoading || stepExecution.executionTimeMs === undefined,
    description: "Execution time",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 21
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    css: styles.tabs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 11
    }
  }, tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => setSelectedTabId(tab.id),
    isSelected: tab.id === selectedTabId,
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 15
    }
  }, tab.name))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: ' ',
    css: styles.flyoutBody,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 7
    }
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 23
    }
  }), selectedTabId === 'input' && renderInput(), selectedTabId === 'output' && renderOutput(), selectedTabId === 'timeline' && renderTimeline()));
};
exports.WorkflowStepExecutionFlyout = WorkflowStepExecutionFlyout;
const componentStyles = {
  flyoutHeader: ({
    euiTheme
  }) => (0, _react2.css)({
    width: '100%',
    borderBottom: `1px solid ${euiTheme.colors.borderBasePlain}`,
    padding: euiTheme.size.s
  }),
  titleContainer: ({
    euiTheme
  }) => (0, _react2.css)({
    padding: euiTheme.size.m
  }),
  title: ({
    euiTheme
  }) => (0, _react2.css)({
    display: 'flex',
    alignItems: 'center',
    gap: euiTheme.size.xs
  }),
  stat: (0, _react2.css)`
    & .euiStat__title {
      margin-block-end: 0;
    }
  `,
  statusBadge: (0, _react2.css)`
    font-weight: 600;
  `,
  tabs: (0, _react2.css)({
    marginBottom: -13
  }),
  flyoutBody: ({
    euiTheme
  }) => (0, _react2.css)({
    padding: euiTheme.size.m
  })
};