"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutionListFilters = ExecutionListFilters;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _workflows = require("@kbn/workflows");
var _react = _interopRequireWildcard(require("react"));
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _react2 = require("@emotion/react");
var _translations = require("../../../shared/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_execution_list/ui/workflow_execution_list_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EQUAL_HEIGHT_OFFSET = 2; // to avoid changes in the header's height after "Clear all" button appears

function ExecutionListFilters({
  filters,
  onFiltersChange
}) {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const filterGroupPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'filterGroupPopover'
  });
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [items, setItems] = (0, _react.useState)([{
    label: _i18n.i18n.translate('workflows.workflowExecutionList.filterIconButton.statusLabel', {
      defaultMessage: 'Status'
    }),
    isGroupLabel: true,
    group: 'status'
  }, ...Object.values(_workflows.ExecutionStatus).map(status => ({
    label: (0, _translations.getStatusLabel)(status),
    key: status,
    checked: filters.statuses.includes(status) ? 'on' : undefined,
    group: 'status'
  })), {
    label: _i18n.i18n.translate('workflows.workflowExecutionList.filterIconButton.executionTypeLabel', {
      defaultMessage: 'Execution type'
    }),
    isGroupLabel: true,
    group: 'executionType'
  }, {
    key: _workflows.ExecutionType.TEST,
    label: _i18n.i18n.translate('workflows.workflowExecutionList.filterIconButton.testLabel', {
      defaultMessage: 'test'
    }),
    checked: filters.executionTypes.includes(_workflows.ExecutionType.TEST) ? 'on' : undefined,
    group: 'executionType'
  }, {
    key: _workflows.ExecutionType.PRODUCTION,
    label: _i18n.i18n.translate('workflows.workflowExecutionList.filterIconButton.productionLabel', {
      defaultMessage: 'production'
    }),
    checked: filters.executionTypes.includes(_workflows.ExecutionType.PRODUCTION) ? 'on' : undefined,
    group: 'executionType'
  }]);
  const handleSelectableOptionsChange = newOptions => {
    setItems(newOptions);
    onFiltersChange({
      statuses: newOptions.filter(item => item.checked === 'on' && item.key && item.group === 'status').map(item => item.key),
      executionTypes: newOptions.filter(item => item.checked === 'on' && item.key && item.group === 'executionType').map(item => item.key)
    });
  };
  const clearAll = () => {
    setItems(items.map(item => ({
      ...item,
      checked: undefined
    })));
    onFiltersChange({
      statuses: [],
      executionTypes: []
    });
  };
  const numActiveFilters = items.filter(item => item.checked === 'on').length;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    compressed: true,
    css: styles.filterGroup,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: filterGroupPopoverId,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
      },
      color: "text",
      badgeColor: numActiveFilters > 0 ? 'accent' : 'subdued',
      isSelected: isPopoverOpen,
      numFilters: numActiveFilters,
      hasActiveFilters: !!numActiveFilters,
      numActiveFilters: numActiveFilters,
      "aria-label": _i18n.i18n.translate('workflows.workflowExecutionList.filterIconButtonAriaLabel', {
        defaultMessage: 'Filter executions'
      }),
      css: styles.filterButtonStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "filter",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 13
      }
    })),
    panelPaddingSize: "none",
    hasArrow: false,
    panelStyle: {
      width: '280px'
    },
    css: styles.popover,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.popoverTitle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('workflows.workflowExecutionList.filterIconButton.title', {
    defaultMessage: 'Filter executions'
  })))), filters.statuses.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: clearAll,
    "data-test-subj": `${filterGroupPopoverId}ClearAll`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('workflows.workflowExecutionList.filterIconButton.clearAllLink', {
    defaultMessage: 'Clear all'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": _i18n.i18n.translate('workflows.workflowExecutionList.filterIconButton.ariaLabel', {
      defaultMessage: 'Filter executions'
    }),
    options: items,
    onChange: handleSelectableOptionsChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 9
    }
  }, list => list)));
}
const componentStyles = {
  popover: (0, _react2.css)`
    & .euiFilterButton__wrapper {
      min-inline-size: 64px;

      &::before,
      &::after {
        display: none !important;
      }
    }
  `,
  popoverTitle: ({
    euiTheme
  }) => (0, _react2.css)`
    padding: ${EQUAL_HEIGHT_OFFSET}px ${euiTheme.size.s};
  `,
  filterGroup: (0, _react2.css)({
    backgroundColor: 'transparent',
    '&::after': {
      border: 'none'
    },
    '&::before': {
      border: 'none'
    }
  }),
  filterButtonStyle: (0, _react2.css)`
    padding: 0;

    &,
    & .euiFilterButton__text {
      min-width: 0;
      line-height: 1;
    }
  `
};