"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowGraphNode = WorkflowGraphNode;
var _eui = require("@elastic/eui");
var _workflows = require("@kbn/workflows");
var _react = require("@xyflow/react");
var _react2 = _interopRequireDefault(require("react"));
var _get_layouted_nodes_and_edges = require("../lib/get_layouted_nodes_and_edges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_visual_editor/ui/workflow_node.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const triggerNodeTypes = ['manual', 'alert', 'scheduled'];
const actionNodeTypes = ['console', 'slack', 'delay', 'inference.unified_inference'];
function getNodeIcon(nodeType, color) {
  switch (nodeType) {
    case 'if':
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
        type: "logstashIf",
        color: color,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 26,
          columnNumber: 14
        }
      });
    case 'merge':
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
        type: "logstashInput",
        color: color,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 28,
          columnNumber: 14
        }
      });
    case 'console':
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
        type: "console",
        color: color,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 30,
          columnNumber: 14
        }
      });
    case 'slack':
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
        type: "logoSlack",
        color: color,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 32,
          columnNumber: 14
        }
      });
    case 'inference.unified_inference':
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
        type: "sparkles",
        color: color,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 34,
          columnNumber: 14
        }
      });
    case 'manual':
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
        type: "accessibility",
        color: color,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 14
        }
      });
    case 'alert':
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: color,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 14
        }
      });
    case 'scheduled':
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
        type: "clock",
        color: color,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 14
        }
      });
    case 'delay':
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
        type: "clock",
        color: color,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 14
        }
      });
    default:
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
        type: "info",
        color: color,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 14
        }
      });
  }
}
function getIconColors(nodeType, euiTheme) {
  if (_get_layouted_nodes_and_edges.flowNodeTypes.includes(nodeType)) {
    return {
      backgroundColor: euiTheme.colors.backgroundBaseWarning,
      color: euiTheme.colors.warning
    };
  }
  if (actionNodeTypes.includes(nodeType)) {
    return {
      backgroundColor: '#F7F8FC',
      color: euiTheme.colors.textSubdued
    };
  }
  if (triggerNodeTypes.includes(nodeType)) {
    return {
      backgroundColor: 'rgba(255, 199, 219, 0.3)',
      color: '#EE72A6'
    };
  }
  return {
    backgroundColor: euiTheme.colors.backgroundBasePrimary,
    color: euiTheme.colors.primary
  };
}
function NodeIcon({
  nodeType
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    backgroundColor,
    color
  } = getIconColors(nodeType, euiTheme);
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: {
      width: '36px',
      height: '36px',
      borderRadius: _get_layouted_nodes_and_edges.flowNodeTypes.includes(nodeType) ? '8px' : '50%',
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center',
      border: _get_layouted_nodes_and_edges.flowNodeTypes.includes(nodeType) ? `1px solid ${color}` : 'none',
      backgroundColor
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, getNodeIcon(nodeType, color));
}
const getNodeBorderColor = (status, euiTheme) => {
  if (!status) {
    return 'transparent';
  }
  switch (status) {
    case _workflows.ExecutionStatus.FAILED:
      return euiTheme.colors.danger;
    case _workflows.ExecutionStatus.COMPLETED:
      return '#16C5C0';
    case _workflows.ExecutionStatus.PENDING:
      return euiTheme.colors.borderBaseNeutral;
    case _workflows.ExecutionStatus.RUNNING:
      return euiTheme.colors.borderBaseNeutral;
    case _workflows.ExecutionStatus.CANCELLED:
      return euiTheme.colors.borderBaseNeutral;
    case _workflows.ExecutionStatus.SKIPPED:
      return euiTheme.colors.borderBaseNeutral;
    case _workflows.ExecutionStatus.WAITING_FOR_INPUT:
      return euiTheme.colors.borderBaseNeutral;
    default:
      return 'transparent';
  }
};

// @ts-expect-error - TODO: fix this
function WorkflowGraphNode(node) {
  var _node$data$stepExecut, _node$data$stepExecut2, _node$data$stepExecut3;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: {
      width: '100%',
      height: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_react.Handle, {
    type: "target",
    position: _react.Position.Top,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: {
      width: '100%',
      height: '100%',
      backgroundColor: euiTheme.colors.backgroundBasePlain,
      borderRadius: '8px',
      padding: '8px 12px',
      boxShadow: '0px 2px 8px 0px rgba(43,57,79,0.05), 0px 1px 4px 0px rgba(43,57,79,0.06), 0px 0px 2px 0px rgba(43,57,79,0.16)',
      display: 'flex',
      alignItems: 'center',
      gap: '12px',
      border: `1px solid ${getNodeBorderColor((_node$data$stepExecut = node.data.stepExecution) === null || _node$data$stepExecut === void 0 ? void 0 : _node$data$stepExecut.status, euiTheme)}`
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: {
      flex: 1,
      width: '100%'
    },
    alignItems: "center",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(NodeIcon, {
    nodeType: node.data.stepType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: {
      flex: 1
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column",
    css: {
      gap: '4px',
      flex: 1,
      width: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: {
      width: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement("span", {
    css: {
      fontSize: '14px',
      fontWeight: 'bold',
      color: euiTheme.colors.textHeading,
      lineHeight: '1.25',
      display: 'flex',
      alignItems: 'center',
      gap: '4px',
      justifyContent: 'space-between'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 17
    }
  }, node.data.label, ((_node$data$stepExecut2 = node.data.stepExecution) === null || _node$data$stepExecut2 === void 0 ? void 0 : _node$data$stepExecut2.status) === _workflows.ExecutionStatus.COMPLETED && /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    color: "#16C5C0",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 21
    }
  }), ((_node$data$stepExecut3 = node.data.stepExecution) === null || _node$data$stepExecut3 === void 0 ? void 0 : _node$data$stepExecut3.status) === _workflows.ExecutionStatus.FAILED && /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "alert",
    color: euiTheme.colors.danger,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react2.default.createElement("div", {
    css: {
      fontSize: '12px',
      color: euiTheme.colors.textSubdued
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 17
    }
  }, node.data.stepType)))))), /*#__PURE__*/_react2.default.createElement(_react.Handle, {
    type: "source",
    position: _react.Position.Bottom,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 7
    }
  }));
}