"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowVisualEditor = WorkflowVisualEditor;
var _react = require("@xyflow/react");
require("@xyflow/react/dist/style.css");
var _react2 = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _get_layouted_nodes_and_edges = require("../lib/get_layouted_nodes_and_edges");
var _workflow_edge = require("./workflow_edge");
var _workflow_node = require("./workflow_node");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/features/workflow_visual_editor/ui/workflow_visual_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const nodeTypes = {
  trigger: _workflow_node.WorkflowGraphNode,
  if: _workflow_node.WorkflowGraphNode,
  merge: _workflow_node.WorkflowGraphNode,
  parallel: _workflow_node.WorkflowGraphNode,
  action: _workflow_node.WorkflowGraphNode,
  foreach: _workflow_node.WorkflowGraphNode,
  atomic: _workflow_node.WorkflowGraphNode
};
const edgeTypes = {
  workflowEdge: _workflow_edge.WorkflowGraphEdge
};
function WorkflowVisualEditor({
  workflow,
  stepExecutions
}) {
  // TODO: call fitView(), when container is resized
  const containerRef = (0, _react2.useRef)(null);
  const reactFlowInstanceRef = (0, _react2.useRef)(null);
  const dimensions = (0, _eui.useResizeObserver)(containerRef.current);
  (0, _react2.useEffect)(() => {
    if (reactFlowInstanceRef.current) {
      reactFlowInstanceRef.current.fitView({
        padding: 1,
        maxZoom: 1,
        minZoom: 0.5
      });
    }
  }, [dimensions]);
  const {
    nodes: initialNodes,
    edges: initialEdges
  } = (0, _get_layouted_nodes_and_edges.getLayoutedNodesAndEdges)(workflow);
  const stepExecutionMap = (0, _react2.useMemo)(() => {
    if (!stepExecutions) {
      return null;
    }
    return stepExecutions === null || stepExecutions === void 0 ? void 0 : stepExecutions.reduce((acc, stepExecution) => {
      acc[stepExecution.stepId] = stepExecution;
      return acc;
    }, {});
  }, [stepExecutions]);
  const {
    nodes,
    edges
  } = (0, _react2.useMemo)(() => {
    if (!stepExecutionMap) {
      return {
        nodes: initialNodes,
        edges: initialEdges
      };
    }
    const finalNodes = initialNodes.map(node => {
      if (stepExecutionMap[node.data.label]) {
        return {
          ...node,
          data: {
            ...node.data,
            stepExecution: stepExecutionMap[node.data.label]
          }
        };
      }
      return node;
    });
    return {
      nodes: finalNodes,
      edges: initialEdges
    };
  }, [initialNodes, initialEdges, stepExecutionMap]);
  return /*#__PURE__*/_react2.default.createElement("div", {
    ref: containerRef,
    css: {
      height: '100%',
      width: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_react.ReactFlow, {
    onInit: instance => {
      reactFlowInstanceRef.current = instance;
    },
    nodes: nodes,
    edges: edges,
    nodeTypes: nodeTypes,
    edgeTypes: edgeTypes,
    fitView: true,
    fitViewOptions: {
      padding: 1
    },
    proOptions: {
      hideAttribution: true
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_react.Controls, {
    orientation: "horizontal",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react2.default.createElement(_react.Background, {
    bgColor: "#F7F8FC",
    color: "#CAD3E2",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  })));
}