"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildContextOverrideForStep = buildContextOverrideForStep;
var _graph = require("@kbn/workflows/graph");
var _uuid = require("uuid");
var _schema = require("../../../../common/schema");
var _yaml_utils = require("../../../../common/lib/yaml_utils");
var _build_step_context_override = require("../../../shared/utils/build_step_context_override/build_step_context_override");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function buildContextOverrideForStep(workflowYaml, stepId) {
  const parsingResult = (0, _yaml_utils.parseWorkflowYamlToJSON)(workflowYaml, (0, _schema.getWorkflowZodSchemaLoose)());
  if (!parsingResult.success) {
    throw parsingResult.error;
  }
  const workflowDefinition = parsingResult.data;
  const stepSubGraph = _graph.WorkflowGraph.fromWorkflowDefinition(workflowDefinition).getStepGraph(stepId);
  return (0, _build_step_context_override.buildContextOverride)(stepSubGraph, {
    consts: workflowDefinition.consts,
    workflow: {
      id: (0, _uuid.v4)(),
      name: workflowDefinition.name,
      enabled: workflowDefinition.enabled || true,
      spaceId: '123'
    }
  });
}