"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowDetailPage = WorkflowDetailPage;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _workflows = require("@kbn/workflows");
var _react2 = _interopRequireWildcard(require("react"));
var _yaml_utils = require("../../../../common/lib/yaml_utils");
var _use_workflow_breadcrumbs = require("../../../hooks/use_workflow_breadcrumbs/use_workflow_breadcrumbs");
var _use_workflow_actions = require("../../../entities/workflows/model/use_workflow_actions");
var _use_workflow_detail = require("../../../entities/workflows/model/use_workflow_detail");
var _use_workflow_execution = require("../../../entities/workflows/model/use_workflow_execution");
var _execution_graph = require("../../../features/debug-graph/execution_graph");
var _workflow_execute_modal = require("../../../features/run_workflow/ui/workflow_execute_modal");
var _workflow_execution_detail = require("../../../features/workflow_execution_detail");
var _workflow_execution_list_stateful = require("../../../features/workflow_execution_list/ui/workflow_execution_list_stateful");
var _use_workflow_url_state = require("../../../hooks/use_workflow_url_state");
var _workflow_detail_header = require("./workflow_detail_header");
var _test_step_modal = require("../../../features/run_workflow/ui/test_step_modal");
var _build_step_context_mock_for_step = require("./build_step_context_mock_for_step");
var _schema = require("../../../../common/schema");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/pages/workflow_detail/ui/workflow_detail_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkflowYAMLEditor = /*#__PURE__*/_react2.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../../widgets/workflow_yaml_editor'))).then(module => ({
  default: module.WorkflowYAMLEditor
})));
const WorkflowVisualEditor = /*#__PURE__*/_react2.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../../features/workflow_visual_editor'))).then(module => ({
  default: module.WorkflowVisualEditor
})));
function WorkflowDetailPage({
  id
}) {
  var _workflow$yaml, _workflow$valid, _workflow$enabled, _workflow$lastUpdated, _workflow$id, _workflow$id2, _workflow$yaml4, _workflow$id3;
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const {
    application,
    uiSettings,
    notifications
  } = (0, _public.useKibana)().services;
  const {
    data: workflow,
    isLoading: isLoadingWorkflow,
    error: workflowError
  } = (0, _use_workflow_detail.useWorkflowDetail)(id);
  (0, _use_workflow_breadcrumbs.useWorkflowsBreadcrumbs)(workflow === null || workflow === void 0 ? void 0 : workflow.name);
  const {
    activeTab,
    selectedExecutionId,
    selectedStepId,
    setActiveTab,
    setSelectedExecution
  } = (0, _use_workflow_url_state.useWorkflowUrlState)();
  const showExecutionSidebar = activeTab === 'executions' || selectedExecutionId;
  const {
    data: execution
  } = (0, _use_workflow_execution.useWorkflowExecution)(selectedExecutionId !== null && selectedExecutionId !== void 0 ? selectedExecutionId : null);
  const [workflowYaml, setWorkflowYaml] = (0, _react2.useState)((_workflow$yaml = workflow === null || workflow === void 0 ? void 0 : workflow.yaml) !== null && _workflow$yaml !== void 0 ? _workflow$yaml : '');
  const originalWorkflowYaml = (0, _react2.useMemo)(() => {
    var _workflow$yaml2;
    return (_workflow$yaml2 = workflow === null || workflow === void 0 ? void 0 : workflow.yaml) !== null && _workflow$yaml2 !== void 0 ? _workflow$yaml2 : '';
  }, [workflow]);
  const [hasChanges, setHasChanges] = (0, _react2.useState)(false);
  const [highlightDiff, setHighlightDiff] = (0, _react2.useState)(false);
  const yamlValue = selectedExecutionId && execution ? execution.yaml : workflowYaml;
  const {
    updateWorkflow,
    runWorkflow,
    runIndividualStep,
    testWorkflow
  } = (0, _use_workflow_actions.useWorkflowActions)();
  const canSaveWorkflow = Boolean(application === null || application === void 0 ? void 0 : application.capabilities.workflowsManagement.updateWorkflow);
  const canRunWorkflow = Boolean(application === null || application === void 0 ? void 0 : application.capabilities.workflowsManagement.executeWorkflow);
  const canTestWorkflow = Boolean(application === null || application === void 0 ? void 0 : application.capabilities.workflowsManagement.executeWorkflow);
  const handleSave = () => {
    if (!id) {
      notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addError(new Error('Workflow is not loaded'), {
        toastLifeTimeMs: 3000,
        title: _i18n.i18n.translate('workflows.workflowDetailHeader.error.workflowNotLoaded', {
          defaultMessage: 'Workflow is not loaded'
        })
      });
      return;
    }
    updateWorkflow.mutate({
      id,
      workflow: {
        yaml: workflowYaml
      }
    }, {
      onError: err => {
        // Extract message from HTTP error body and update the error message
        if (err && typeof err === 'object' && 'body' in err && err.body && typeof err.body === 'object' && 'message' in err.body && typeof err.body.message === 'string') {
          err.message = err.body.message;
        }
        notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addError(err, {
          toastLifeTimeMs: 3000,
          title: 'Failed to save workflow'
        });
      }
    });
  };
  const [workflowExecuteModalOpen, setWorkflowExecuteModalOpen] = (0, _react2.useState)(false);
  const [testWorkflowModalOpen, setTestWorkflowModalOpen] = (0, _react2.useState)(false);
  const definitionFromCurrentYaml = (0, _react2.useMemo)(() => {
    const parsingResult = (0, _yaml_utils.parseWorkflowYamlToJSON)(workflowYaml, (0, _schema.getWorkflowZodSchemaLoose)());
    if (!parsingResult.success) {
      return null;
    }
    return parsingResult.data;
  }, [workflowYaml]);
  const [testStepId, setTestStepId] = (0, _react2.useState)(null);
  const [contextOverride, setcontextOverride] = (0, _react2.useState)(null);
  const handleRunClick = ({
    test = false
  }) => {
    const def = test ? definitionFromCurrentYaml : workflow === null || workflow === void 0 ? void 0 : workflow.definition;
    let needInput = false;
    if (def !== null && def !== void 0 && def.triggers) {
      needInput = def.triggers.some(trigger => trigger.type === 'alert') || def.triggers.some(trigger => trigger.type === 'manual') && def.inputs && Object.keys(def.inputs).length > 0;
    }
    if (needInput) {
      if (test) {
        setTestWorkflowModalOpen(true);
      } else {
        setWorkflowExecuteModalOpen(true);
      }
    } else {
      if (test) {
        handleTestRunWorkflow({});
      } else {
        handleRunWorkflow({});
      }
    }
  };
  const handleRunWorkflow = event => {
    if (!workflow) {
      notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addError(new Error('Workflow is not loaded'), {
        toastLifeTimeMs: 3000,
        title: _i18n.i18n.translate('workflows.workflowDetailHeader.error.workflowNotLoaded', {
          defaultMessage: 'Workflow is not loaded'
        })
      });
      return;
    }
    runWorkflow.mutate({
      id,
      inputs: event
    }, {
      onSuccess: ({
        workflowExecutionId
      }) => {
        notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addSuccess(_i18n.i18n.translate('workflows.workflowDetailHeader.success.workflowRunStarted', {
          defaultMessage: 'Workflow run started'
        }), {
          toastLifeTimeMs: 3000
        });
        setSelectedExecution(workflowExecutionId);
      },
      onError: err => {
        notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addError(err, {
          toastLifeTimeMs: 3000,
          title: _i18n.i18n.translate('workflows.workflowDetailHeader.error.workflowRunFailed', {
            defaultMessage: 'Failed to run workflow'
          })
        });
      }
    });
  };
  const handleTestRunWorkflow = event => {
    testWorkflow.mutate({
      workflowYaml,
      inputs: event
    }, {
      onSuccess: ({
        workflowExecutionId
      }) => {
        notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addSuccess(_i18n.i18n.translate('workflows.workflowDetailHeader.success.workflowTestRunStarted', {
          defaultMessage: 'Workflow test run started'
        }), {
          toastLifeTimeMs: 3000
        });
        setSelectedExecution(workflowExecutionId);
      },
      onError: err => {
        notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addError(err, {
          toastLifeTimeMs: 3000,
          title: _i18n.i18n.translate('workflows.workflowDetailHeader.error.workflowTestRunFailed', {
            defaultMessage: 'Failed to test workflow'
          })
        });
      }
    });
  };
  const handleToggleWorkflow = (0, _react2.useCallback)(() => {
    if (!workflow) {
      notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addError(new Error('Workflow is not loaded'), {
        toastLifeTimeMs: 3000,
        title: _i18n.i18n.translate('workflows.workflowDetailHeader.error.workflowNotLoaded', {
          defaultMessage: 'Workflow is not loaded'
        })
      });
      return;
    }
    updateWorkflow.mutate({
      id,
      workflow: {
        enabled: !workflow.enabled
      }
    }, {
      onError: err => {
        notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addError(err, {
          toastLifeTimeMs: 3000,
          title: 'Failed to update workflow'
        });
      }
    });
  }, [notifications === null || notifications === void 0 ? void 0 : notifications.toasts, updateWorkflow, id, workflow]);
  const isVisualEditorEnabled = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get(_workflows.WORKFLOWS_UI_VISUAL_EDITOR_SETTING_ID, false);
  const isExecutionGraphEnabled = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get(_workflows.WORKFLOWS_UI_EXECUTION_GRAPH_SETTING_ID, false);
  (0, _react2.useEffect)(() => {
    var _workflow$yaml3;
    setWorkflowYaml((_workflow$yaml3 = workflow === null || workflow === void 0 ? void 0 : workflow.yaml) !== null && _workflow$yaml3 !== void 0 ? _workflow$yaml3 : '');
    setHasChanges(false);
  }, [workflow]);
  const handleChange = wfString => {
    setWorkflowYaml(wfString);
    setHasChanges(originalWorkflowYaml !== wfString);
  };
  const handleStepRun = async params => {
    if (params.actionType === 'run') {
      const contextOverrideData = (0, _build_step_context_mock_for_step.buildContextOverrideForStep)(workflowYaml, params.stepId);
      if (!Object.keys(contextOverrideData.stepContext).length) {
        submitStepRun(params.stepId, {});
        return;
      }
      setcontextOverride(contextOverrideData);
      setTestStepId(params.stepId);
    }
  };
  const submitStepRun = async (stepId, mock) => {
    const response = await runIndividualStep.mutateAsync({
      stepId,
      workflowYaml,
      contextOverride: mock
    });
    setSelectedExecution(response.workflowExecutionId);
    setTestStepId(null);
    setcontextOverride(null);
  };
  if (workflowError) {
    const error = workflowError;
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "error",
      color: "danger",
      title: /*#__PURE__*/_react2.default.createElement("h2", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 301,
          columnNumber: 16
        }
      }, "Unable to load workflow"),
      body: /*#__PURE__*/_react2.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 302,
          columnNumber: 15
        }
      }, "There was an error loading the workflow. ", error.message),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: styles.pageContainer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_workflow_detail_header.WorkflowDetailHeader, {
    name: workflow === null || workflow === void 0 ? void 0 : workflow.name,
    isLoading: isLoadingWorkflow,
    activeTab: activeTab,
    canRunWorkflow: canRunWorkflow,
    canSaveWorkflow: canSaveWorkflow,
    isValid: (_workflow$valid = workflow === null || workflow === void 0 ? void 0 : workflow.valid) !== null && _workflow$valid !== void 0 ? _workflow$valid : true,
    isEnabled: (_workflow$enabled = workflow === null || workflow === void 0 ? void 0 : workflow.enabled) !== null && _workflow$enabled !== void 0 ? _workflow$enabled : false,
    handleRunClick: () => handleRunClick({
      test: false
    }),
    handleSave: handleSave,
    handleToggleWorkflow: handleToggleWorkflow,
    canTestWorkflow: canTestWorkflow,
    handleTestClick: () => handleRunClick({
      test: true
    }),
    handleTabChange: tab => {
      setActiveTab(tab);
    },
    hasUnsavedChanges: hasChanges,
    highlightDiff: highlightDiff,
    setHighlightDiff: setHighlightDiff,
    lastUpdatedAt: (_workflow$lastUpdated = workflow === null || workflow === void 0 ? void 0 : workflow.lastUpdatedAt) !== null && _workflow$lastUpdated !== void 0 ? _workflow$lastUpdated : null,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    css: styles.container,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: styles.main,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: styles.yamlEditor,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_react2.default.Suspense, {
    fallback: /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 334,
        columnNumber: 41
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(WorkflowYAMLEditor, {
    workflowId: (_workflow$id = workflow === null || workflow === void 0 ? void 0 : workflow.id) !== null && _workflow$id !== void 0 ? _workflow$id : 'unknown',
    filename: `${(_workflow$id2 = workflow === null || workflow === void 0 ? void 0 : workflow.id) !== null && _workflow$id2 !== void 0 ? _workflow$id2 : 'unknown'}.yaml`,
    value: yamlValue,
    onChange: v => handleChange(v !== null && v !== void 0 ? v : ''),
    lastUpdatedAt: workflow === null || workflow === void 0 ? void 0 : workflow.lastUpdatedAt,
    hasChanges: hasChanges,
    highlightStep: selectedStepId,
    stepExecutions: execution === null || execution === void 0 ? void 0 : execution.stepExecutions,
    readOnly: activeTab === 'executions',
    selectedExecutionId: selectedExecutionId,
    originalValue: (_workflow$yaml4 = workflow === null || workflow === void 0 ? void 0 : workflow.yaml) !== null && _workflow$yaml4 !== void 0 ? _workflow$yaml4 : '',
    onStepActionClicked: handleStepRun,
    highlightDiff: highlightDiff,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 17
    }
  }))), isVisualEditorEnabled && workflow && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: styles.visualEditor,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_react2.default.Suspense, {
    fallback: /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 354,
        columnNumber: 43
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(WorkflowVisualEditor, {
    workflowYaml: yamlValue,
    workflowExecutionId: selectedExecutionId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 19
    }
  }))), isExecutionGraphEnabled && workflow && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: styles.visualEditor,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_react2.default.Suspense, {
    fallback: /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 364,
        columnNumber: 43
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_execution_graph.ExecutionGraph, {
    workflowYaml: yamlValue,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 19
    }
  }))))), showExecutionSidebar && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: styles.sidebar,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 11
    }
  }, !selectedExecutionId && /*#__PURE__*/_react2.default.createElement(_workflow_execution_list_stateful.WorkflowExecutionList, {
    workflowId: (_workflow$id3 = workflow === null || workflow === void 0 ? void 0 : workflow.id) !== null && _workflow$id3 !== void 0 ? _workflow$id3 : null,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 38
    }
  }), workflow && selectedExecutionId && /*#__PURE__*/_react2.default.createElement(_workflow_execution_detail.WorkflowExecutionDetail, {
    workflowExecutionId: selectedExecutionId,
    workflowYaml: yamlValue,
    showBackButton: activeTab === 'executions',
    onClose: () => setSelectedExecution(null),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 15
    }
  }))), workflowExecuteModalOpen && workflow && /*#__PURE__*/_react2.default.createElement(_workflow_execute_modal.WorkflowExecuteModal, {
    definition: workflow.definition,
    onClose: () => setWorkflowExecuteModalOpen(false),
    onSubmit: handleRunWorkflow,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 9
    }
  }), testWorkflowModalOpen && definitionFromCurrentYaml && /*#__PURE__*/_react2.default.createElement(_workflow_execute_modal.WorkflowExecuteModal, {
    definition: definitionFromCurrentYaml,
    onClose: () => setTestWorkflowModalOpen(false),
    onSubmit: handleTestRunWorkflow,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 393,
      columnNumber: 9
    }
  }), testStepId && contextOverride && /*#__PURE__*/_react2.default.createElement(_test_step_modal.TestStepModal, {
    initialcontextOverride: contextOverride,
    onSubmit: ({
      stepInputs
    }) => submitStepRun(testStepId, stepInputs),
    onClose: () => {
      setTestStepId(null);
      setcontextOverride(null);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 400,
      columnNumber: 9
    }
  }));
}
const componentStyles = {
  pageContainer: (0, _react.css)({
    display: 'flex',
    flexDirection: 'column',
    flex: '1 1 0',
    overflow: 'hidden'
  }),
  container: (0, _react.css)`
    flex: 1;
    height: 100%;
    min-height: 0;
    flex-wrap: nowrap !important;
  `,
  main: (0, _react.css)({
    flex: 1,
    overflow: 'hidden'
  }),
  yamlEditor: (0, _react.css)({
    flex: 1,
    overflow: 'hidden'
  }),
  visualEditor: ({
    euiTheme
  }) => (0, _react.css)({
    flex: 1,
    overflow: 'hidden',
    borderLeft: `1px solid ${euiTheme.colors.borderBasePlain}`
  }),
  sidebar: ({
    euiTheme
  }) => (0, _react.css)({
    maxWidth: '300px',
    flex: 1,
    borderLeft: `1px solid ${euiTheme.colors.borderBasePlain}`
  })
};