"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowsPlugin = void 0;
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _constants = require("@kbn/workflows/common/constants");
var _common = require("../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// Lazy import to avoid bundling connector dependencies in main plugin

class WorkflowsPlugin {
  setup(core, plugins) {
    // Register workflows connector UI component lazily to reduce main bundle size
    const registerConnectorType = async () => {
      const {
        getWorkflowsConnectorType
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./connectors/workflows')));
      plugins.triggersActionsUi.actionTypeRegistry.register(getWorkflowsConnectorType());
    };

    // Register the connector type immediately but load it lazily
    registerConnectorType();

    // Check if workflows UI is enabled
    const isWorkflowsUiEnabled = core.uiSettings.get(_constants.WORKFLOWS_UI_SETTING_ID, false);
    if (isWorkflowsUiEnabled) {
      core.application.register({
        id: _common.PLUGIN_ID,
        title: _common.PLUGIN_NAME,
        appRoute: '/app/workflows',
        euiIconType: 'merge',
        // TODO: use "workflowsAll" when available
        visibleIn: ['globalSearch', 'home', 'kibanaOverview', 'sideNav'],
        category: _public.DEFAULT_APP_CATEGORIES.management,
        order: 9015,
        mount: async params => {
          // Load application bundle
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
          const services = await this.createWorkflowsStartServices(core);

          // Set badge for classic navbar
          services.chrome.setBadge({
            text: 'Technical preview',
            tooltip: 'This functionality is in technical preview. It may change or be removed in a future release.',
            iconType: 'beaker'
          });
          return renderApp(services, params);
        }
      });
    }

    // Return methods that should be available to other plugins
    return {};
  }
  start(core) {
    return {};
  }
  stop() {}

  /** Creates the start services to be used in the Kibana services context of the workflows application */
  async createWorkflowsStartServices(core) {
    // Get start services as specified in kibana.jsonc
    const [coreStart, depsStart] = await core.getStartServices();
    const additionalServices = {
      storage: new _public2.Storage(localStorage)
    };
    return {
      ...coreStart,
      ...depsStart,
      ...additionalServices
    };
  }
}
exports.WorkflowsPlugin = WorkflowsPlugin;