"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowsRoutes = WorkflowsRoutes;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _workflow_detail = require("./pages/workflow_detail");
var _workflows = require("./pages/workflows");
var _access_denied = require("../common/components/access_denied");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/routes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const WorkflowsPermissionsWrapper = ({
  permissions,
  children
}) => {
  var _services$application, _services$application2;
  const {
    services
  } = (0, _public.useKibana)();
  const capabilities = (_services$application = services.application) === null || _services$application === void 0 ? void 0 : (_services$application2 = _services$application.capabilities) === null || _services$application2 === void 0 ? void 0 : _services$application2.workflowsManagement;
  let havePermissions;
  if (!capabilities) {
    havePermissions = false;
  } else {
    havePermissions = permissions.some(permission => {
      return !!capabilities[permission];
    });
  }
  if (!havePermissions) {
    return /*#__PURE__*/_react.default.createElement(_access_denied.AccessDenied, {
      requirements: permissions,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 12
      }
    });
  }
  return children;
};
function WorkflowsRoutes({
  history
}) {
  // Render the application DOM.
  // Note that `navigation.ui.TopNavMenu` is a stateful component exported on the `navigation` plugin's start contract.
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/:id",
    render: props => /*#__PURE__*/_react.default.createElement(WorkflowsPermissionsWrapper, {
      permissions: ['read', 'readWorkflow'],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_workflow_detail.WorkflowDetailPage, {
      id: props.match.params.id,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 17
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/",
    exact: true,
    render: () => /*#__PURE__*/_react.default.createElement(WorkflowsPermissionsWrapper, {
      permissions: ['read', 'readWorkflow'],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_workflows.WorkflowsPage, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 17
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }))));
}