"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STATUS_LABELS = void 0;
exports.getStatusLabel = getStatusLabel;
var _i18n = require("@kbn/i18n");
var _workflows = require("@kbn/workflows");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const STATUS_LABELS = exports.STATUS_LABELS = {
  [_workflows.ExecutionStatus.PENDING]: _i18n.i18n.translate('workflowsManagement.executionStatus.pending', {
    defaultMessage: 'Pending'
  }),
  [_workflows.ExecutionStatus.WAITING]: _i18n.i18n.translate('workflowsManagement.executionStatus.waiting', {
    defaultMessage: 'Waiting'
  }),
  [_workflows.ExecutionStatus.WAITING_FOR_INPUT]: _i18n.i18n.translate('workflowsManagement.executionStatus.waitingForInput', {
    defaultMessage: 'Waiting'
  }),
  [_workflows.ExecutionStatus.RUNNING]: _i18n.i18n.translate('workflowsManagement.executionStatus.running', {
    defaultMessage: 'Running'
  }),
  [_workflows.ExecutionStatus.COMPLETED]: _i18n.i18n.translate('workflowsManagement.executionStatus.completed', {
    defaultMessage: 'Success'
  }),
  [_workflows.ExecutionStatus.FAILED]: _i18n.i18n.translate('workflowsManagement.executionStatus.failed', {
    defaultMessage: 'Error'
  }),
  [_workflows.ExecutionStatus.CANCELLED]: _i18n.i18n.translate('workflowsManagement.executionStatus.cancelled', {
    defaultMessage: 'Canceled'
  }),
  [_workflows.ExecutionStatus.TIMED_OUT]: _i18n.i18n.translate('workflowsManagement.executionStatus.timedOut', {
    defaultMessage: 'Timed out'
  }),
  [_workflows.ExecutionStatus.SKIPPED]: _i18n.i18n.translate('workflowsManagement.executionStatus.skipped', {
    defaultMessage: 'Skipped'
  })
};

/**
 * Gets the localized label for a given execution status
 */
function getStatusLabel(status) {
  return STATUS_LABELS[status];
}