"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JSONDataView = JSONDataView;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _useWindowSize = _interopRequireDefault(require("react-use/lib/useWindowSize"));
var _react2 = require("@emotion/react");
var _json_data_code = require("./json_data_code");
var _json_data_table = require("./json_data_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/shared/ui/json_data_view/json_data_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Displayed margin of the tab content to the window bottom
const DEFAULT_MARGIN_BOTTOM = 16;
function JSONDataView({
  data,
  title = 'JSON Data',
  columns,
  searchTerm,
  onSearchTermChange,
  'data-test-subj': dataTestSubj = 'jsonDataTable'
}) {
  const [viewMode, setViewMode] = (0, _react.useState)('table');
  const contentRef = (0, _react.useRef)(null);
  const {
    height: windowHeight
  } = (0, _useWindowSize.default)();
  const [contentTop, setContentTop] = (0, _react.useState)(0);
  (0, _react.useLayoutEffect)(() => {
    if (contentRef.current) {
      var _contentRef$current$g;
      setContentTop((_contentRef$current$g = contentRef.current.getBoundingClientRect().top) !== null && _contentRef$current$g !== void 0 ? _contentRef$current$g : 0);
    }
  }, []);

  // Set the height of the content container to available space in flyout, the data table and the json editor will handle the overflow
  const contentHeight = contentRef.current ? windowHeight - contentTop - DEFAULT_MARGIN_BOTTOM : 0;

  // Convert data to object format if needed
  const jsonObject = (0, _react.useMemo)(() => {
    if (Array.isArray(data)) {
      return data[0] || {};
    }

    // If data is already an object, use it directly
    if (data && typeof data === 'object' && data !== null) {
      return data;
    }

    // For primitive values, wrap them in an object
    if (data !== undefined && data !== null) {
      return {
        value: data
      };
    }
    return {};
  }, [data]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": dataTestSubj,
    direction: "column",
    gutterSize: "none",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, viewMode === 'table' && onSearchTermChange && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    compressed: true,
    fullWidth: true,
    placeholder: "Filter by field, value",
    value: searchTerm,
    onChange: e => onSearchTermChange(e.target.value),
    isClearable: true,
    "aria-label": _i18n.i18n.translate('workflows.jsonDataTable.searchAriaLabel', {
      defaultMessage: 'Search fields and values'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      justifySelf: 'flex-end',
      marginLeft: 'auto'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isIconOnly: true,
    buttonSize: "compressed",
    color: "primary",
    type: "single",
    idSelected: viewMode,
    legend: _i18n.i18n.translate('workflows.jsonDataTable.viewMode', {
      defaultMessage: 'View mode'
    }),
    onChange: id => setViewMode(id),
    options: [{
      id: 'table',
      label: _i18n.i18n.translate('workflows.jsonDataTable.viewMode.table', {
        defaultMessage: 'Table'
      }),
      iconType: 'tableDensityNormal'
    }, {
      id: 'json',
      label: _i18n.i18n.translate('workflows.jsonDataTable.viewMode.json', {
        defaultMessage: 'JSON'
      }),
      iconType: 'code'
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    ref: contentRef,
    css: contentHeight ? (0, _react2.css)({
      minBlockSize: 0,
      height: contentHeight + 'px',
      overflow: 'hidden'
    }) : (0, _react2.css)({
      display: 'block'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }, viewMode === 'table' && /*#__PURE__*/_react.default.createElement(_json_data_table.JSONDataTable, {
    data: jsonObject,
    title: title,
    columns: columns,
    searchTerm: searchTerm,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  }), viewMode === 'json' && /*#__PURE__*/_react.default.createElement(_json_data_code.JsonDataCode, {
    json: jsonObject,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 35
    }
  }))));
}