"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonCodeEditorCommon = exports.JSONCodeEditorCommonMemoized = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/shared/ui/json_data_view/json_editor_common.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const codeEditorAriaLabel = _i18n.i18n.translate('workflows.jsonDataView.codeEditorAriaLabel', {
  defaultMessage: 'Read only JSON view'
});
const copyToClipboardLabel = _i18n.i18n.translate('workflows.jsonDataView.copyToClipboardLabel', {
  defaultMessage: 'Copy to clipboard'
});
const JsonCodeEditorCommon = ({
  jsonValue,
  width,
  height,
  hasLineNumbers,
  onEditorDidMount,
  hideCopyButton,
  enableFindAction
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  (0, _react.useEffect)(() => {
    _monaco.monaco.editor.defineTheme('workflows-subdued', {
      base: 'vs',
      inherit: true,
      rules: [],
      colors: {
        'editor.background': euiTheme.colors.backgroundBaseSubdued
      }
    });
  }, [euiTheme]);
  if (jsonValue === '') {
    return null;
  }
  const codeEditor = /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: "json",
    width: width,
    height: height,
    value: jsonValue || '',
    editorDidMount: onEditorDidMount,
    "aria-label": codeEditorAriaLabel,
    options: {
      theme: 'workflows-subdued',
      automaticLayout: true,
      fontSize: 12,
      // prevent line numbers margin from being too wide
      lineNumbersMinChars: hasLineNumbers ? 2 : 0,
      lineNumbers: hasLineNumbers ? 'on' : 'off',
      minimap: {
        enabled: false
      },
      overviewRulerBorder: false,
      readOnly: true,
      scrollbar: {
        alwaysConsumeMouseWheel: false
      },
      scrollBeyondLastLine: false,
      wordWrap: 'on',
      wrappingIndent: 'indent'
    },
    enableFindAction: enableFindAction,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  });
  if (hideCopyButton) {
    return codeEditor;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: styles.codeEditor,
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.copyButtonContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: jsonValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    iconType: "copyClipboard",
    onClick: copy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }, copyToClipboardLabel))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, codeEditor));
};
exports.JsonCodeEditorCommon = JsonCodeEditorCommon;
const JSONCodeEditorCommonMemoized = exports.JSONCodeEditorCommonMemoized = /*#__PURE__*/_react.default.memo(props => {
  return /*#__PURE__*/_react.default.createElement(JsonCodeEditorCommon, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 10
    }
  }));
});
const componentStyles = {
  codeEditor: ({
    euiTheme
  }) => (0, _react2.css)`
    height: 100%;
    padding: 0 ${euiTheme.size.s} ${euiTheme.size.m} ${euiTheme.size.s};
    background-color: ${euiTheme.colors.backgroundBaseSubdued};
    border-radius: ${euiTheme.border.radius.medium};
  `,
  copyButtonContainer: ({
    euiTheme
  }) => (0, _react2.css)`
    padding: ${euiTheme.size.m} ${euiTheme.size.m} 0 0;
    display: flex;
    flex-direction: row;
    justify-content: flex-end;
    z-index: 2;
  `
};