"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableFieldValue = exports.DOC_VIEWER_DEFAULT_TRUNCATE_MAX_HEIGHT = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _discoverUtils = require("@kbn/discover-utils");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/shared/ui/json_data_view/table_field_value.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// copied from unified_doc_viewer/public/components/doc_viewer_table/table_cell_value.tsx

const DOC_VIEWER_DEFAULT_TRUNCATE_MAX_HEIGHT = exports.DOC_VIEWER_DEFAULT_TRUNCATE_MAX_HEIGHT = 110;

// Keep in memory what field values were expanded by the user and restore this state when the user opens DocViewer again
const expandedFieldValuesSet = new Set();
const IgnoreWarning = /*#__PURE__*/_react2.default.memo(({
  rawValue,
  reason
}) => {
  const multiValue = Array.isArray(rawValue) && rawValue.length > 1;
  const getToolTipContent = () => {
    switch (reason) {
      case _discoverUtils.IgnoredReason.IGNORE_ABOVE:
        return multiValue ? _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.multiAboveTooltip', {
          defaultMessage: `One or more values in this field are too long and can't be searched or filtered.`
        }) : _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.singleAboveTooltip', {
          defaultMessage: `The value in this field is too long and can't be searched or filtered.`
        });
      case _discoverUtils.IgnoredReason.MALFORMED:
        return multiValue ? _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.multiMalformedTooltip', {
          defaultMessage: `This field has one or more malformed values that can't be searched or filtered.`
        }) : _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.singleMalformedTooltip', {
          defaultMessage: `The value in this field is malformed and can't be searched or filtered.`
        });
      case _discoverUtils.IgnoredReason.UNKNOWN:
        return multiValue ? _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.multiUnknownTooltip', {
          defaultMessage: `One or more values in this field were ignored by Elasticsearch and can't be searched or filtered.`
        }) : _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.singleUnknownTooltip', {
          defaultMessage: `The value in this field was ignored by Elasticsearch and can't be searched or filtered.`
        });
    }
  };
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: getToolTipContent(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false,
    alignItems: "center",
    css: (0, _react.css)`
          cursor: help;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextColor, {
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, multiValue ? _i18n.i18n.translate('unifiedDocViewer.docViews.table.ignored.multiValueLabel', {
    defaultMessage: 'Contains ignored values'
  }) : _i18n.i18n.translate('unifiedDocViewer.docViews.table.ignored.singleValueLabel', {
    defaultMessage: 'Ignored value'
  })))));
});
const TableFieldValue = ({
  formattedValue,
  field,
  rawValue,
  ignoreReason,
  isDetails,
  isHighlighted
}) => {
  var _containerRef$scrollH;
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const truncationHeight = DOC_VIEWER_DEFAULT_TRUNCATE_MAX_HEIGHT;
  const [containerRef, setContainerRef] = (0, _react2.useState)(null);
  (0, _eui.useResizeObserver)(containerRef);
  const containerScrollHeight = (_containerRef$scrollH = containerRef === null || containerRef === void 0 ? void 0 : containerRef.scrollHeight) !== null && _containerRef$scrollH !== void 0 ? _containerRef$scrollH : 0;
  const [isValueExpanded, setIsValueExpanded] = (0, _react2.useState)(expandedFieldValuesSet.has(field));
  const isCollapsible = !isDetails && Boolean(rawValue) && truncationHeight > 0 && containerScrollHeight > 0 && containerScrollHeight > truncationHeight;
  const isCollapsed = isCollapsible && !isValueExpanded;
  const onToggleCollapse = (0, _react2.useCallback)(() => setIsValueExpanded(isExpandedPrev => {
    const isExpandedNext = !isExpandedPrev;
    if (isExpandedNext) {
      expandedFieldValuesSet.add(field);
    } else {
      expandedFieldValuesSet.delete(field);
    }
    return isExpandedNext;
  }), [field, setIsValueExpanded]);
  const toggleButtonLabel = isCollapsed ? _i18n.i18n.translate('unifiedDocViewer.docViews.table.viewMoreButton', {
    defaultMessage: 'View more'
  }) : _i18n.i18n.translate('unifiedDocViewer.docViews.table.viewLessButton', {
    defaultMessage: 'View less'
  });
  const shouldTruncate = isCollapsible && isCollapsed;
  const valueElementId = `tableDocViewRow-${field}-value`;
  return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 5
    }
  }, ignoreReason && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(IgnoreWarning, {
    reason: ignoreReason,
    rawValue: rawValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "row",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }, isCollapsible && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.collapseButtonWrapper,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    iconType: isCollapsed ? 'plusInSquare' : 'minusInSquare',
    size: "xs",
    color: "primary",
    "data-test-subj": `toggleLongFieldValue-${field}`,
    title: toggleButtonLabel,
    "aria-label": toggleButtonLabel,
    "aria-expanded": !isCollapsed,
    "aria-controls": valueElementId,
    onClick: onToggleCollapse,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    ref: setContainerRef,
    className: "kbnDocViewer__value",
    css: [styles.docViewerValue, isHighlighted && !isDetails && styles.docViewerValueHighlighted, shouldTruncate && styles.docViewerValueTruncated],
    id: valueElementId,
    "data-test-subj": valueElementId
    // Value returned from formatFieldValue is always sanitized
    // eslint-disable-next-line react/no-danger
    ,
    dangerouslySetInnerHTML: {
      __html: formattedValue
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  }))));
};
exports.TableFieldValue = TableFieldValue;
const componentStyles = {
  docViewerValue: themeContext => {
    const {
      euiTheme
    } = themeContext;
    const {
      fontSize
    } = (0, _eui.euiFontSize)(themeContext, 's');
    return (0, _react.css)({
      wordBreak: 'break-all',
      wordWrap: 'break-word',
      whiteSpace: 'pre-wrap',
      lineHeight: euiTheme.font.lineHeightMultiplier,
      verticalAlign: 'top',
      '.euiDataGridRowCell__popover &': {
        fontSize
      }
    });
  },
  docViewerValueHighlighted: ({
    euiTheme
  }) => (0, _react.css)({
    fontWeight: euiTheme.font.weight.bold
  }),
  docViewerValueTruncated: (0, _react.css)({
    overflow: 'hidden',
    maxHeight: DOC_VIEWER_DEFAULT_TRUNCATE_MAX_HEIGHT
  }),
  collapseButtonWrapper: ({
    euiTheme
  }) => (0, _react.css)({
    marginTop: -euiTheme.size.xxs
  })
};