"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusBadge = StatusBadge;
exports.getExecutionStatusIcon = exports.getExecutionStatusColors = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _workflows = require("@kbn/workflows");
var _react = _interopRequireDefault(require("react"));
var _translations = require("../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/shared/ui/status_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getExecutionStatusColorsMap = euiTheme => {
  return {
    [_workflows.ExecutionStatus.COMPLETED]: {
      color: euiTheme.colors.vis.euiColorVisSuccess0,
      backgroundColor: euiTheme.colors.backgroundBaseSuccess,
      tokenColor: 'euiColorVis0'
    },
    [_workflows.ExecutionStatus.FAILED]: {
      color: euiTheme.colors.danger,
      backgroundColor: euiTheme.colors.backgroundBaseDanger,
      tokenColor: 'euiColorVis6'
    },
    [_workflows.ExecutionStatus.PENDING]: {
      color: euiTheme.colors.textSubdued,
      backgroundColor: euiTheme.colors.backgroundBaseSubdued,
      tokenColor: 'gray'
    },
    [_workflows.ExecutionStatus.RUNNING]: {
      color: euiTheme.colors.textSubdued,
      backgroundColor: euiTheme.colors.backgroundLightNeutral,
      tokenColor: 'euiColorVis3'
    },
    [_workflows.ExecutionStatus.WAITING]: {
      color: euiTheme.colors.warning,
      backgroundColor: euiTheme.colors.backgroundBaseWarning,
      tokenColor: 'euiColorVis9'
    },
    [_workflows.ExecutionStatus.WAITING_FOR_INPUT]: {
      color: euiTheme.colors.warning,
      backgroundColor: euiTheme.colors.backgroundBaseWarning,
      tokenColor: 'euiColorVis9'
    },
    [_workflows.ExecutionStatus.CANCELLED]: {
      color: euiTheme.colors.textSubdued,
      backgroundColor: euiTheme.colors.backgroundBaseSubdued,
      tokenColor: 'gray'
    },
    [_workflows.ExecutionStatus.TIMED_OUT]: {
      color: euiTheme.colors.danger,
      backgroundColor: euiTheme.colors.backgroundBaseDanger,
      tokenColor: 'euiColorVis6'
    },
    [_workflows.ExecutionStatus.SKIPPED]: {
      color: euiTheme.colors.textDisabled,
      backgroundColor: euiTheme.colors.backgroundBaseSubdued,
      tokenColor: 'gray'
    }
  };
};
const getExecutionStatusColors = (euiTheme, status) => {
  if (!status) {
    return {
      color: euiTheme.colors.textSubdued,
      backgroundColor: euiTheme.colors.backgroundBaseSubdued,
      tokenColor: 'gray'
    };
  }
  return getExecutionStatusColorsMap(euiTheme)[status];
};
exports.getExecutionStatusColors = getExecutionStatusColors;
const ExecutionStatusIconTypeMap = {
  [_workflows.ExecutionStatus.COMPLETED]: 'checkInCircleFilled',
  [_workflows.ExecutionStatus.FAILED]: 'errorFilled',
  [_workflows.ExecutionStatus.TIMED_OUT]: 'errorFilled',
  [_workflows.ExecutionStatus.PENDING]: 'clock',
  [_workflows.ExecutionStatus.RUNNING]: 'play',
  [_workflows.ExecutionStatus.WAITING]: 'clock',
  [_workflows.ExecutionStatus.WAITING_FOR_INPUT]: 'dot',
  [_workflows.ExecutionStatus.CANCELLED]: 'crossInCircle',
  [_workflows.ExecutionStatus.SKIPPED]: 'minusInCircleFilled'
};
const getExecutionStatusIcon = (euiTheme, status) => {
  if (status === _workflows.ExecutionStatus.RUNNING) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 12
      }
    });
  }
  if (status === _workflows.ExecutionStatus.WAITING_FOR_INPUT) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBeacon, {
      size: 14,
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: ExecutionStatusIconTypeMap[status],
    color: getExecutionStatusColors(euiTheme, status).color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 5
    }
  });
};
exports.getExecutionStatusIcon = getExecutionStatusIcon;
function StatusBadge({
  status,
  textProps,
  ...props
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!status) return;
  const statusLabel = (0, _translations.getStatusLabel)(status);
  const icon = getExecutionStatusIcon(euiTheme, status);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
    alignItems: "center",
    gutterSize: "xs"
  }, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }, icon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-hideFor--s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, (0, _extends2.default)({
    size: "s"
  }, textProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }), statusLabel)));
}