"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnsavedChangesPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/shared/ui/unsaved_changes_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UnsavedChangesPrompt = ({
  hasUnsavedChanges,
  shouldPromptOnNavigation = true
}) => {
  const location = (0, _reactRouterDom.useLocation)();
  const currentPathRef = (0, _react.useRef)(location.pathname);

  // Keep ref up to date with current path
  (0, _react.useEffect)(() => {
    currentPathRef.current = location.pathname;
  }, [location.pathname]);
  (0, _react.useEffect)(() => {
    const handler = event => {
      if (hasUnsavedChanges) {
        // These 2 lines of code are the recommendation from MDN for triggering a browser prompt for confirming
        // whether or not a user wants to leave the current site.
        event.preventDefault();
        event.returnValue = '';
      }
    };
    // Adding this handler will prompt users if they are navigating to a new page, outside of the Kibana SPA
    window.addEventListener('beforeunload', handler);
    return () => window.removeEventListener('beforeunload', handler);
  }, [hasUnsavedChanges]);
  const message = nextLocation => {
    const nextPath = nextLocation === null || nextLocation === void 0 ? void 0 : nextLocation.pathname;
    const currentPath = currentPathRef.current;

    // Check if navigation is within the same workflow (tab navigation)
    // Look for workflow ID in the path (could be /app/workflows/workflow-123 or /workflow-123)
    const getWorkflowId = path => {
      const parts = path.split('/');
      const workflowIndex = parts.findIndex(part => part.startsWith('workflow-'));
      return workflowIndex !== -1 ? parts[workflowIndex] : null;
    };
    const currentWorkflowId = getWorkflowId(currentPath);
    const nextWorkflowId = getWorkflowId(nextPath || '');
    const isSameWorkflow = currentWorkflowId && nextWorkflowId && currentWorkflowId === nextWorkflowId;

    // Only show prompt if leaving the workflow
    if (isSameWorkflow) {
      return true; // Allow navigation within same workflow
    }

    // Show browser's native confirmation dialog
    return 'Your changes have not been saved. Are you sure you want to leave?';
  };
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Prompt, {
    when: hasUnsavedChanges && shouldPromptOnNavigation,
    message: message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 10
    }
  });
};
exports.UnsavedChangesPrompt = UnsavedChangesPrompt;