"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildContextOverride = buildContextOverride;
var _utils = require("@kbn/workflows/common/utils");
var _workflows = require("@kbn/workflows");
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const StepContextSchemaPropertyPaths = (0, _utils.extractSchemaPropertyPaths)(_workflows.StepContextSchema);
function buildStepContextSchemaFromObject(obj) {
  if (Array.isArray(obj)) {
    return _zod.z.array(buildStepContextSchemaFromObject(obj[0]));
  } else if (typeof obj === 'object' && obj !== null) {
    const config = {};
    Object.keys(obj).forEach(key => {
      config[key] = buildStepContextSchemaFromObject(obj[key]);
    });
    return _zod.z.object(config).strict();
  }
  return _zod.z.any();
}
function readPropertyRecursive(propertyPath, object) {
  if (typeof object === 'object' && object !== null && propertyPath.length) {
    const currentProp = propertyPath[0];
    return readPropertyRecursive(propertyPath.slice(1), object[currentProp]);
  }
  return object;
}
function buildContextOverride(workflowGraph, staticData) {
  const contextOverride = {};
  const inputsInGraph = (0, _utils.findInputsInGraph)(workflowGraph);
  const allInputs = Object.values(inputsInGraph).flat();
  const allInputsFiltered = allInputs.filter(input => StepContextSchemaPropertyPaths.some(schemaPropertyPath => input.startsWith(schemaPropertyPath.path)));
  const inputsParsed = allInputsFiltered.map(input => (0, _utils.parseJsPropertyAccess)(input));
  inputsParsed.forEach(pathParts => {
    let current = contextOverride;
    for (let i = 0; i < pathParts.length; i++) {
      const part = pathParts[i];
      const isLastPart = i === pathParts.length - 1;
      if (isLastPart) {
        // Set a default value for the final property
        current[part] = current[part] || readPropertyRecursive(pathParts.slice(0, i + 1), staticData) || 'replace with your data';
      } else {
        // Create nested object if it doesn't exist
        if (!current[part]) {
          current[part] = {};
        }
        current = current[part];
      }
    }
  });
  const schema = buildStepContextSchemaFromObject(contextOverride);
  return {
    stepContext: contextOverride,
    schema
  };
}