"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRegisterKeyboardCommands = useRegisterKeyboardCommands;
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const OPEN_ACTIONS_POPOVER_ACTION_ID = 'openActionsPopover';
function useRegisterKeyboardCommands() {
  const actionsMenuAction = (0, _react.useRef)(null);
  const unregisterKeyboardCommands = () => {
    if (actionsMenuAction.current) {
      actionsMenuAction.current.dispose();
    }
  };
  const registerKeyboardCommands = params => {
    unregisterKeyboardCommands();
    const {
      editor,
      openActionsPopover
    } = params;
    // CMD+K shortcut, while focus is on the editor
    actionsMenuAction.current = editor.addAction({
      id: OPEN_ACTIONS_POPOVER_ACTION_ID,
      label: _i18n.i18n.translate('workflows.workflowDetail.yamlEditor.action.openActionsPopover', {
        defaultMessage: 'Open actions popover'
      }),
      // eslint-disable-next-line no-bitwise
      keybindings: [_monaco.monaco.KeyMod.CtrlCmd | _monaco.monaco.KeyCode.KeyK],
      run: openActionsPopover
    });
  };
  return {
    registerKeyboardCommands,
    unregisterKeyboardCommands
  };
}