"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkerSeverity = void 0;
exports.getMonacoRangeFromYamlNode = getMonacoRangeFromYamlNode;
exports.getSeverityString = getSeverityString;
exports.navigateToErrorPosition = navigateToErrorPosition;
var _monaco = require("@kbn/monaco");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// Copied from monaco-editor/esm/vs/editor/editor.api.d.ts because we can't import with turbopack
let MarkerSeverity = exports.MarkerSeverity = /*#__PURE__*/function (MarkerSeverity) {
  MarkerSeverity[MarkerSeverity["Hint"] = 1] = "Hint";
  MarkerSeverity[MarkerSeverity["Info"] = 2] = "Info";
  MarkerSeverity[MarkerSeverity["Warning"] = 4] = "Warning";
  MarkerSeverity[MarkerSeverity["Error"] = 8] = "Error";
  return MarkerSeverity;
}({});
function getSeverityString(severity) {
  switch (severity) {
    case MarkerSeverity.Error:
      return 'error';
    case MarkerSeverity.Warning:
      return 'warning';
    case MarkerSeverity.Info:
    case MarkerSeverity.Hint:
    default:
      return 'info';
  }
}
function navigateToErrorPosition(editor, lineNumber, column) {
  editor.setPosition({
    lineNumber,
    column
  });
  editor.focus();
  editor.revealLineInCenter(lineNumber);
}

// REMOVED: getHighlightStepDecorations - no longer needed
// All step highlighting is now handled by UnifiedActionsProvider

function getMonacoRangeFromYamlNode(model, node) {
  var _node$range;
  const [startOffset, _, endOffset] = (_node$range = node.range) !== null && _node$range !== void 0 ? _node$range : [];
  if (!startOffset || !endOffset) {
    return null;
  }
  const startPos = model.getPositionAt(startOffset);
  const endPos = model.getPositionAt(endOffset);
  if (!startPos || !endPos) {
    return null;
  }
  const range = new _monaco.monaco.Range(startPos.lineNumber, startPos.column, endPos.lineNumber, endPos.column);
  return range;
}