"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchStepActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _run_step_button = require("./run_step_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/widgets/workflow_yaml_editor/ui/elasticsearch_step_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ElasticsearchStepActions = ({
  actionsProvider,
  http,
  notifications,
  esHost,
  kibanaHost,
  onStepActionClicked
}) => {
  var _actionsProvider$getC;
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  // Use state to force re-renders when actions change
  const [, setRefreshTrigger] = (0, _react.useState)(0);

  // Listen for action updates - force refresh every 100ms when actions might change
  (0, _react.useEffect)(() => {
    const interval = setInterval(() => {
      setRefreshTrigger(prev => prev + 1);
    }, 100);
    return () => clearInterval(interval);
  }, []);
  const currentStep = actionsProvider === null || actionsProvider === void 0 ? void 0 : actionsProvider.getCurrentElasticsearchStep();
  const currentActions = (actionsProvider === null || actionsProvider === void 0 ? void 0 : (_actionsProvider$getC = actionsProvider.getCurrentActions) === null || _actionsProvider$getC === void 0 ? void 0 : _actionsProvider$getC.call(actionsProvider)) || [];
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: () => {
      setIsPopoverOpen(prev => !prev);
    },
    "data-test-subj": "toggleConsoleMenu",
    "aria-label": _i18n.i18n.translate('console.requestOptionsButtonAriaLabel', {
      defaultMessage: 'Request options'
    }),
    iconType: "boxesVertical",
    iconSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  });
  const items = [...((currentActions === null || currentActions === void 0 ? void 0 : currentActions.map((action, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": `actionButton-${action.id}`,
    key: action.id || index,
    onClick: () => {
      action.handler();
      closePopover();
    },
    icon: action.icon,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, action.label))) || [])];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: styles.buttonsGroup,
    gutterSize: "xs",
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, currentStep && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_run_step_button.RunStepButton, {
    onClick: () => onStepActionClicked === null || onStepActionClicked === void 0 ? void 0 : onStepActionClicked({
      stepId: currentStep.name,
      actionType: 'run'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  })), !!items.length && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "contextMenu",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items,
    "data-test-subj": "consoleMenu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }))));
};
exports.ElasticsearchStepActions = ElasticsearchStepActions;
const componentStyles = {
  buttonsGroup: ({
    euiTheme
  }) => (0, _react2.css)({
    backgroundColor: euiTheme.colors.backgroundBasePlain,
    padding: euiTheme.size.xs,
    borderRadius: euiTheme.border.radius.small,
    boxShadow: '0 2px 4px rgba(0, 0, 0, 0.1)'
  })
};