"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchStepHoverMenuCompact = exports.ElasticsearchStepHoverMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _copy_request_utils = require("../lib/copy_request_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/widgets/workflow_yaml_editor/ui/elasticsearch_step_hover_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ElasticsearchStepHoverMenu = ({
  step,
  http,
  notifications,
  esHost,
  kibanaHost,
  anchorPosition = 'downLeft'
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const copyAsOptions = {
    http,
    notifications,
    esHost,
    kibanaHost
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "copyClipboard",
    size: "s",
    onClick: () => setIsPopoverOpen(!isPopoverOpen),
    "data-test-subj": "elasticsearchStepCopyAsButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "workflows.workflowDetail.yamlEditor.elasticsearchStep.copyAs",
    defaultMessage: "Copy as",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }));
  const handleCopyAs = async language => {
    setIsPopoverOpen(false);
    await (0, _copy_request_utils.copyStepAs)(step, language, copyAsOptions);
  };
  const handleCopyAsConsole = async () => {
    setIsPopoverOpen(false);
    await (0, _copy_request_utils.copyAsConsole)(step, copyAsOptions);
  };
  const items = [
  /*#__PURE__*/
  // Console format first
  _react.default.createElement(_eui.EuiContextMenuItem, {
    key: "console",
    "data-test-subj": "copyAsConsole",
    onClick: handleCopyAsConsole,
    icon: "console",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "workflows.workflowDetail.yamlEditor.elasticsearchStep.copyAsConsole",
    defaultMessage: "Console format",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  })),
  // Then language formats
  ..._copy_request_utils.COPY_AS_LANGUAGES.map(({
    value,
    label
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: value,
    "data-test-subj": `copyAs${value}`,
    onClick: () => handleCopyAs(value),
    icon: "copyClipboard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, label))];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "elasticsearchStepHoverMenu",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: anchorPosition,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      minWidth: 200
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      padding: '8px 12px',
      borderBottom: '1px solid #d3dae6'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "storage",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "workflows.workflowDetail.yamlEditor.elasticsearchStep.title",
    defaultMessage: "Elasticsearch API",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 15
    }
  }, step.method, " ", step.url)))), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items,
    "data-test-subj": "elasticsearchStepCopyAsMenu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  })));
};

/**
 * Compact version of the hover menu for inline display
 */
exports.ElasticsearchStepHoverMenu = ElasticsearchStepHoverMenu;
const ElasticsearchStepHoverMenuCompact = ({
  step,
  http,
  notifications,
  esHost,
  kibanaHost,
  anchorPosition = 'downLeft'
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const copyAsOptions = {
    http,
    notifications,
    esHost,
    kibanaHost
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "boxesVertical",
    size: "s",
    fill: false,
    onClick: () => setIsPopoverOpen(!isPopoverOpen),
    "data-test-subj": "elasticsearchStepMenuButton",
    "aria-label": _i18n.i18n.translate('workflows.workflowDetail.yamlEditor.elasticsearchStep.menuAriaLabel', {
      defaultMessage: 'Elasticsearch step options'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 5
    }
  });
  const handleCopyAs = async language => {
    setIsPopoverOpen(false);
    await (0, _copy_request_utils.copyStepAs)(step, language, copyAsOptions);
  };
  const handleCopyAsConsole = async () => {
    setIsPopoverOpen(false);
    await (0, _copy_request_utils.copyAsConsole)(step, copyAsOptions);
  };
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "console",
    "data-test-subj": "copyAsConsole",
    onClick: handleCopyAsConsole,
    icon: "console",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "workflows.workflowDetail.yamlEditor.elasticsearchStep.copyAsConsole",
    defaultMessage: "Copy as Console",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "curl",
    "data-test-subj": "copyAsCurl",
    onClick: () => handleCopyAs('curl'),
    icon: "copyClipboard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "workflows.workflowDetail.yamlEditor.elasticsearchStep.copyAsCurl",
    defaultMessage: "Copy as cURL",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 7
    }
  }))];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "elasticsearchStepHoverMenuCompact",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: anchorPosition,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items,
    "data-test-subj": "elasticsearchStepMenuCompact",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 7
    }
  }));
};
exports.ElasticsearchStepHoverMenuCompact = ElasticsearchStepHoverMenuCompact;