"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowYAMLValidationErrors = WorkflowYAMLValidationErrors;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/workflows_management/public/widgets/workflow_yaml_editor/ui/workflow_yaml_validation_errors.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const severityOrder = ['error', 'warning', 'info'];
function WorkflowYAMLValidationErrors({
  isMounted,
  error: errorValidating,
  validationErrors,
  onErrorClick,
  rightSide
}) {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'wf-yaml-editor-validation-errors'
  });
  let icon = null;
  let buttonContent = null;
  const highestSeverity = validationErrors === null || validationErrors === void 0 ? void 0 : validationErrors.reduce((acc, error) => {
    if (error.severity === 'error') {
      return 'error';
    }
    if (error.severity === 'warning' && acc !== 'error') {
      return 'warning';
    }
    if (error.severity === 'info' && acc !== 'error' && acc !== 'warning') {
      return 'info';
    }
    return acc;
  }, null);
  if (!isMounted) {
    icon = /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 12
      }
    });
    buttonContent = 'Loading editor...';
  } else if (errorValidating) {
    icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "error",
      color: "danger",
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 12
      }
    });
    buttonContent = errorValidating.message;
  } else if (!validationErrors) {
    icon = /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 12
      }
    });
    buttonContent = 'Initializing validation...';
  } else if ((validationErrors === null || validationErrors === void 0 ? void 0 : validationErrors.length) === 0) {
    icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "checkInCircleFilled",
      color: euiTheme.colors.vis.euiColorVisSuccess0,
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 7
      }
    });
    buttonContent = 'No validation errors';
  } else {
    icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: highestSeverity === 'error' ? 'errorFilled' : 'warningFilled',
      color: highestSeverity === 'error' ? 'danger' : euiTheme.colors.vis.euiColorVis8,
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 7
      }
    });
    buttonContent = `${validationErrors === null || validationErrors === void 0 ? void 0 : validationErrors.length} validation ${(validationErrors === null || validationErrors === void 0 ? void 0 : validationErrors.length) === 1 ? 'error' : 'errors'}`;
  }
  const sortedValidationErrors = validationErrors === null || validationErrors === void 0 ? void 0 : validationErrors.sort((a, b) => {
    if (a.lineNumber === b.lineNumber) {
      if (a.column === b.column) {
        return severityOrder.indexOf(a.severity) - severityOrder.indexOf(b.severity);
      }
      return a.column - b.column;
    }
    return a.lineNumber - b.lineNumber;
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    "data-testid": "wf-yaml-editor-validation-errors-list",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      css: styles.buttonContent,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 11
      }
    }, icon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: styles.buttonContentText,
      className: "button-content-text",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 11
      }
    }, buttonContent), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: styles.buttonContentRightSide,
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 11
      }
    }, rightSide)),
    arrowDisplay: validationErrors !== null && validationErrors.length > 0 ? 'left' : 'none',
    initialIsOpen: validationErrors !== null && validationErrors.length > 0,
    isDisabled: validationErrors == null || validationErrors.length === 0,
    css: styles.accordion,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.separator,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.accordionContent,
    className: "eui-yScrollWithShadows",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, sortedValidationErrors === null || sortedValidationErrors === void 0 ? void 0 : sortedValidationErrors.map((error, index) => /*#__PURE__*/_react.default.createElement("button", {
    key: `${error.lineNumber}-${error.column}-${error.message}-${index}-${error.severity}`,
    css: styles.validationError,
    onClick: () => onErrorClick === null || onErrorClick === void 0 ? void 0 : onErrorClick(error),
    onKeyDown: e => {
      if (e.key === 'Enter' || e.key === ' ') {
        e.preventDefault();
        onErrorClick === null || onErrorClick === void 0 ? void 0 : onErrorClick(error);
      }
    },
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.validationErrorLineNumber,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 17
    }
  }, error.lineNumber), ":", error.column), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: error.severity === 'error' ? 'errorFilled' : error.severity === 'warning' ? 'warningFilled' : 'iInCircle',
    color: error.severity === 'error' ? 'danger' : error.severity === 'warning' ? euiTheme.colors.vis.euiColorVis8 : 'primary',
    size: "s",
    css: styles.validationErrorIcon,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 17
    }
  }, error.message)))))));
}
const componentStyles = {
  accordion: ({
    euiTheme
  }) => (0, _react2.css)({
    height: '100%',
    padding: `0 ${euiTheme.size.m}`,
    borderTop: `1px solid ${euiTheme.colors.borderBasePlain}`,
    backgroundColor: euiTheme.colors.backgroundBasePlain,
    '& .euiAccordion__buttonContent': {
      width: '100%'
    },
    // apply underline only to the button content text, not the right side
    '& .euiAccordion__button:hover, & .euiAccordion__button:focus': {
      textDecoration: 'none !important',
      '& .button-content-text': {
        textDecoration: 'underline'
      }
    }
  }),
  buttonContent: ({
    euiTheme
  }) => (0, _react2.css)`
    width: 100%;
    padding: ${euiTheme.size.m} 0;
    color: ${euiTheme.colors.textParagraph};
    flex-wrap: nowrap !important;
  `,
  buttonContentText: euiThemeContext => (0, _react2.css)({
    ...(0, _eui.euiFontSize)(euiThemeContext, 'xs'),
    whiteSpace: 'nowrap'
  }),
  buttonContentRightSide: (0, _react2.css)({
    justifySelf: 'flex-end'
  }),
  accordionContent: ({
    euiTheme
  }) => (0, _react2.css)({
    maxHeight: '200px',
    overflowY: 'auto',
    padding: euiTheme.size.s,
    position: 'relative'
  }),
  separator: ({
    euiTheme
  }) => (0, _react2.css)({
    borderTop: `1px solid ${euiTheme.colors.borderBasePlain}`
  }),
  validationError: euiThemeContext => (0, _react2.css)({
    ...(0, _eui.euiFontSize)(euiThemeContext, 'xs'),
    // override default button styles
    textAlign: 'left',
    cursor: 'pointer',
    display: 'flex',
    flexDirection: 'row',
    alignItems: 'flex-start',
    gap: euiThemeContext.euiTheme.size.s,
    '&:hover': {
      textDecoration: 'underline'
    }
  }),
  validationErrorLineNumber: (0, _react2.css)({
    minWidth: '3rem',
    display: 'block'
  }),
  validationErrorIcon: (0, _react2.css)({
    marginTop: '0.125rem',
    flexShrink: 0
  })
};