"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createServiceError = void 0;
var _axios = require("axios");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createServiceError = (error, message) => {
  if ((0, _axios.isAxiosError)(error)) {
    var _error$response;
    const responseData = (_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.data;
    const errorMessage = (responseData === null || responseData === void 0 ? void 0 : responseData.message) || error.message;
    return new Error(`${message}. Error: ${errorMessage}`);
  }
  return new Error(`${message}. Error: ${error.message}`);
};
exports.createServiceError = createServiceError;