"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.workflowIndexName = exports.createStorage = void 0;
var _storageAdapter = require("@kbn/storage-adapter");
var _indices = require("./indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const workflowIndexName = exports.workflowIndexName = (0, _indices.workflowSystemIndex)('workflows');

// ✅ RUDOLF'S SUGGESTED APPROACH
const storageSettings = {
  name: workflowIndexName,
  schema: {
    properties: {
      // ONLY map fields we actively search/filter/aggregate on
      name: _storageAdapter.types.text({
        fields: {
          keyword: {
            type: 'keyword',
            ignore_above: 256
          }
        }
      }),
      description: _storageAdapter.types.text({
        fields: {
          keyword: {
            type: 'keyword',
            ignore_above: 256
          }
        }
      }),
      enabled: _storageAdapter.types.boolean({}),
      // We filter by this
      tags: _storageAdapter.types.keyword({}),
      // We search by this
      createdBy: _storageAdapter.types.keyword({}),
      // We filter by this
      spaceId: _storageAdapter.types.keyword({}),
      // We filter by this
      updated_at: _storageAdapter.types.date({}),
      // We sort by this
      // Non-searchable fields (stored but not indexed)
      yaml: _storageAdapter.types.text({
        index: false
      }),
      definition: _storageAdapter.types.object({
        enabled: false
      }),
      deleted_at: _storageAdapter.types.date({}),
      valid: _storageAdapter.types.boolean({}),
      created_at: _storageAdapter.types.date({}),
      lastUpdatedBy: _storageAdapter.types.keyword({})
    }
  }
};

// @ts-expect-error type mismatch for tags type

const createStorage = ({
  logger,
  esClient
}) => {
  // @ts-expect-error type mismatch for tags type
  return new _storageAdapter.StorageIndexAdapter(esClient, logger, storageSettings);
};
exports.createStorage = createStorage;