"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUISettings = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/workflows/common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerUISettings = ({
  uiSettings
}) => {
  uiSettings.register({
    [_constants.WORKFLOWS_UI_SETTING_ID]: {
      description: _i18n.i18n.translate('workflowsManagement.uiSettings.ui.description', {
        defaultMessage: 'Enables the workflows management UI for creating and managing workflows.'
      }),
      name: _i18n.i18n.translate('workflowsManagement.uiSettings.ui.name', {
        defaultMessage: 'Workflows Management UI'
      }),
      schema: _configSchema.schema.boolean(),
      value: false,
      readonly: true,
      readonlyMode: 'ui'
    }
  });
};
exports.registerUISettings = registerUISettings;