"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchStepExecutions = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const searchStepExecutions = async ({
  esClient,
  logger,
  stepsExecutionIndex,
  workflowExecutionId,
  additionalQuery,
  spaceId
}) => {
  try {
    logger.info(`Searching workflows in index ${stepsExecutionIndex}`);
    const mustQueries = [{
      match: {
        workflowRunId: workflowExecutionId
      }
    }, {
      term: {
        spaceId
      }
    }];
    if (additionalQuery) {
      mustQueries.push(additionalQuery);
    }
    const response = await esClient.search({
      index: stepsExecutionIndex,
      query: {
        bool: {
          must: mustQueries
        }
      },
      sort: 'startedAt:desc',
      from: 0,
      size: 1000 // TODO: without it, it returns up to 10 results by default. We should improve this.
    });
    logger.info(`Found ${response.hits.hits.length} workflows, ${response.hits.hits.map(hit => hit._id)}`);
    return response.hits.hits.map(hit => hit._source)
    // TODO: It should be sorted on ES side
    // This sort is needed to ensure steps are returned in the execution order
    .sort((fst, scd) => fst.globalExecutionIndex - scd.globalExecutionIndex);
  } catch (error) {
    logger.error(`Failed to search workflows: ${error}`);
    throw error;
  }
};
exports.searchStepExecutions = searchStepExecutions;