"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findInputsInGraph = findInputsInGraph;
var _extract_nunjucks_variables = require("../extract_nunjucks_variables/extract_nunjucks_variables");
var _extract_property_paths_from_kql = require("../extract_property_paths_from_kql/extract_property_paths_from_kql");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function findInputsInGraph(workflowGraph) {
  const inputsInSteps = {};
  const nodes = workflowGraph.topologicalOrder.map(nodeId => workflowGraph.getNode(nodeId));
  for (const node of nodes) {
    let stepInputsKey;
    let stepInputs = [];
    const isInForeach = workflowGraph.getNodeStack(node.id).some(nodeId => workflowGraph.getNode(nodeId).type === 'enter-foreach');
    if (node.type === 'enter-if') {
      const ifNode = node;
      const ifInput = ifNode.configuration.condition;
      const kqlVariables = (0, _extract_property_paths_from_kql.extractPropertyPathsFromKql)(ifInput);
      kqlVariables.forEach(variable => stepInputs.push(variable));
      stepInputsKey = ifNode.stepId;
    }
    if (node.type === 'enter-foreach') {
      const enterForeachNode = node;
      const foreachInput = node.configuration.foreach;
      let shouldInclude = true;
      try {
        shouldInclude = !Array.isArray(JSON.parse(foreachInput));
      } catch {
        // If parsing fails, keep it as a string
      }
      if (shouldInclude) {
        stepInputs.push(node.configuration.foreach);
        stepInputsKey = enterForeachNode.stepId;
      }
    }
    if (node.type === 'atomic') {
      const atomicNode = node;
      stepInputsKey = atomicNode.stepId;
      Object.values(atomicNode.configuration.with).forEach(input => {
        if (typeof input !== 'string') {
          return;
        }
        (0, _extract_nunjucks_variables.extractNunjucksVariables)(input).forEach(variable => stepInputs.push(variable));
      });
    }
    if (isInForeach) {
      stepInputs = stepInputs.filter(input => !input.startsWith('foreach.'));
    }
    if (stepInputsKey && stepInputs.length) {
      inputsInSteps[stepInputsKey] = stepInputs;
    }
  }
  return inputsInSteps;
}