"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStepByNameFromNestedSteps = getStepByNameFromNestedSteps;
var _utils = require("../types/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getStepByNameFromNestedSteps(steps, stepName) {
  for (const step of steps) {
    if (step.name === stepName) {
      return step;
    }
    if ((0, _utils.isForeachStep)(step) && Array.isArray(step.steps)) {
      const result = getStepByNameFromNestedSteps(step.steps, stepName);
      if (result) {
        return result;
      }
    }
    if ((0, _utils.isIfStep)(step) && Array.isArray(step.steps)) {
      const result = getStepByNameFromNestedSteps(step.steps, stepName);
      if (result) {
        return result;
      }
    }
    if ((0, _utils.isIfStep)(step) && Array.isArray(step.else)) {
      const result = getStepByNameFromNestedSteps(step.else, stepName);
      if (result) {
        return result;
      }
    }
    if ((0, _utils.isParallelStep)(step) && Array.isArray(step.branches)) {
      for (const branch of step.branches) {
        const result = getStepByNameFromNestedSteps(branch.steps, stepName);
        if (result) {
          return result;
        }
      }
    }
    if ((0, _utils.isMergeStep)(step) && Array.isArray(step.steps)) {
      const result = getStepByNameFromNestedSteps(step.steps, stepName);
      if (result) {
        return result;
      }
    }
  }
  return null;
}