"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExitIfNodeSchema = exports.ExitConditionBranchNodeSchema = exports.EnterIfNodeSchema = exports.EnterIfNodeConfigurationSchema = exports.EnterConditionBranchNodeSchema = void 0;
var _zod = require("@kbn/zod");
var _schema = require("../../../spec/schema");
var _base = require("./base");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const EnterIfNodeConfigurationSchema = exports.EnterIfNodeConfigurationSchema = _schema.IfStepSchema.omit({
  steps: true,
  else: true
});
const EnterIfNodeSchema = exports.EnterIfNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('enter-if'),
  exitNodeId: _zod.z.string(),
  configuration: EnterIfNodeConfigurationSchema
});
const EnterConditionBranchNodeSchema = exports.EnterConditionBranchNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.union([_zod.z.literal('enter-then-branch'), _zod.z.literal('enter-else-branch')]),
  condition: _zod.z.union([_zod.z.string(), _zod.z.undefined()])
});
const ExitConditionBranchNodeSchema = exports.ExitConditionBranchNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.union([_zod.z.literal('exit-then-branch'), _zod.z.literal('exit-else-branch')]),
  startNodeId: _zod.z.string()
});
const ExitIfNodeSchema = exports.ExitIfNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('exit-if'),
  startNodeId: _zod.z.string()
});