"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateWorkflowCommandSchema = exports.TestWorkflowResponseSchema = exports.TestWorkflowCommandSchema = exports.SearchWorkflowCommandSchema = exports.RunWorkflowResponseSchema = exports.RunWorkflowCommandSchema = exports.RunStepCommandSchema = exports.ExecutionTypeValues = exports.ExecutionType = exports.ExecutionStatusValues = exports.ExecutionStatus = exports.EsWorkflowSchema = exports.CreateWorkflowCommandSchema = void 0;
var _zod = require("@kbn/zod");
var _schema = require("../spec/schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let ExecutionStatus = exports.ExecutionStatus = /*#__PURE__*/function (ExecutionStatus) {
  ExecutionStatus["PENDING"] = "pending";
  ExecutionStatus["WAITING"] = "waiting";
  ExecutionStatus["WAITING_FOR_INPUT"] = "waiting_for_input";
  ExecutionStatus["RUNNING"] = "running";
  ExecutionStatus["COMPLETED"] = "completed";
  ExecutionStatus["FAILED"] = "failed";
  ExecutionStatus["CANCELLED"] = "cancelled";
  ExecutionStatus["TIMED_OUT"] = "timed_out";
  ExecutionStatus["SKIPPED"] = "skipped";
  return ExecutionStatus;
}({});
const ExecutionStatusValues = exports.ExecutionStatusValues = Object.values(ExecutionStatus);
let ExecutionType = exports.ExecutionType = /*#__PURE__*/function (ExecutionType) {
  ExecutionType["TEST"] = "test";
  ExecutionType["PRODUCTION"] = "production";
  return ExecutionType;
}({});
const ExecutionTypeValues = exports.ExecutionTypeValues = Object.values(ExecutionType);

/**
 * An interface representing the state of a step scope during workflow execution.
 */

// TODO: convert to actual elastic document spec

const EsWorkflowSchema = exports.EsWorkflowSchema = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string(),
  description: _zod.z.string().optional(),
  enabled: _zod.z.boolean(),
  tags: _zod.z.array(_zod.z.string()),
  createdAt: _zod.z.date(),
  createdBy: _zod.z.string(),
  lastUpdatedAt: _zod.z.date(),
  lastUpdatedBy: _zod.z.string(),
  definition: _schema.WorkflowSchema,
  deleted_at: _zod.z.date().nullable().default(null),
  yaml: _zod.z.string(),
  valid: _zod.z.boolean().readonly()
});
const CreateWorkflowCommandSchema = exports.CreateWorkflowCommandSchema = _zod.z.object({
  yaml: _zod.z.string()
});
const UpdateWorkflowCommandSchema = exports.UpdateWorkflowCommandSchema = _zod.z.object({
  name: _zod.z.string(),
  description: _zod.z.string().optional(),
  enabled: _zod.z.boolean(),
  tags: _zod.z.array(_zod.z.string()),
  yaml: _zod.z.string()
});
const SearchWorkflowCommandSchema = exports.SearchWorkflowCommandSchema = _zod.z.object({
  triggerType: _zod.z.string().optional(),
  limit: _zod.z.number().default(100),
  page: _zod.z.number().default(0),
  createdBy: _zod.z.array(_zod.z.string()).optional(),
  // bool or number transformed to boolean
  enabled: _zod.z.array(_zod.z.union([_zod.z.boolean(), _zod.z.number().transform(val => val === 1)])).optional(),
  query: _zod.z.string().optional(),
  _full: _zod.z.boolean().default(false)
});
const RunWorkflowCommandSchema = exports.RunWorkflowCommandSchema = _zod.z.object({
  inputs: _zod.z.record(_zod.z.any())
});
const RunStepCommandSchema = exports.RunStepCommandSchema = _zod.z.object({
  workflowYaml: _zod.z.string(),
  stepId: _zod.z.string(),
  contextOverride: _zod.z.record(_zod.z.any()).optional()
});
const TestWorkflowCommandSchema = exports.TestWorkflowCommandSchema = _zod.z.object({
  workflowYaml: _zod.z.string(),
  inputs: _zod.z.record(_zod.z.any())
});
const RunWorkflowResponseSchema = exports.RunWorkflowResponseSchema = _zod.z.object({
  workflowExecutionId: _zod.z.string()
});
const TestWorkflowResponseSchema = exports.TestWorkflowResponseSchema = _zod.z.object({
  workflowExecutionId: _zod.z.string()
});