"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isoToEpoch = isoToEpoch;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function isoToEpoch(input, ctx) {
  const epoch = new Date(input).getTime();
  if (isNaN(epoch)) {
    ctx.addIssue({
      code: _zod.z.ZodIssueCode.custom,
      message: 'Invalid ISO date string'
    });
    return _zod.z.NEVER;
  }
  return epoch;
}