"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IsMigrationStage = exports.LDMigrationStage = void 0;
/**
 * Stage denotes one of six possible stages a technology migration could be a
 * part of, progressing through the following order.
 *
 * Off -> DualWrite -> Shadow -> Live -> RampDown -> Complete
 */
var LDMigrationStage;
(function (LDMigrationStage) {
    /**
     * Off - migration hasn't started, "old" is authoritative for reads and writes
     */
    LDMigrationStage["Off"] = "off";
    /**
     * DualWrite - write to both "old" and "new", "old" is authoritative for reads
     */
    LDMigrationStage["DualWrite"] = "dualwrite";
    /**
     * Shadow - both "new" and "old" versions run with a preference for "old"
     */
    LDMigrationStage["Shadow"] = "shadow";
    /**
     * Live - both "new" and "old" versions run with a preference for "new"
     */
    LDMigrationStage["Live"] = "live";
    /**
     * RampDown - only read from "new", write to "old" and "new"
     */
    LDMigrationStage["RampDown"] = "rampdown";
    /**
     * Complete - migration is done
     */
    LDMigrationStage["Complete"] = "complete";
})(LDMigrationStage || (exports.LDMigrationStage = LDMigrationStage = {}));
/**
 * Check if the given string is a migration stage.
 * @param value The string to check.
 * @returns True if the string is a migration stage.
 */
function IsMigrationStage(value) {
    return Object.values(LDMigrationStage).includes(value);
}
exports.IsMigrationStage = IsMigrationStage;
//# sourceMappingURL=LDMigrationStage.js.map