"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPluginEnvironmentMetadata = void 0;
function createPluginEnvironmentMetadata(_platform, _sdkKey, config) {
    const environmentMetadata = {
        sdk: {
            name: _platform.info.sdkData().userAgentBase,
            version: _platform.info.sdkData().version,
        },
        sdkKey: _sdkKey,
    };
    if (_platform.info.sdkData().wrapperName) {
        environmentMetadata.sdk.wrapperName = _platform.info.sdkData().wrapperName;
    }
    if (_platform.info.sdkData().wrapperVersion) {
        environmentMetadata.sdk.wrapperVersion = _platform.info.sdkData().wrapperVersion;
    }
    if (config.applicationInfo) {
        environmentMetadata.application = config.applicationInfo;
    }
    return environmentMetadata;
}
exports.createPluginEnvironmentMetadata = createPluginEnvironmentMetadata;
//# sourceMappingURL=createPluginEnvironmentMetadata.js.map