"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const stream_1 = require("stream");
const zlib = require("zlib");
const HeaderWrapper_1 = require("./HeaderWrapper");
class NodeResponse {
    constructor(res) {
        this.chunks = [];
        this.memoryStream = new stream_1.Writable({
            decodeStrings: true,
            write: (chunk, _enc, next) => {
                this.chunks.push(chunk);
                next();
            },
        });
        this.listened = false;
        this.headers = new HeaderWrapper_1.default(res.headers);
        // Status code is optionally typed, but will always be present for this
        // use case.
        this.status = res.statusCode || 0;
        this.incomingMessage = res;
        this.promise = new Promise((resolve, reject) => {
            // Called on error or completion of the pipeline.
            const pipelineCallback = (err) => {
                if (err) {
                    this.rejection = err;
                    if (this.listened) {
                        reject(err);
                    }
                }
                return resolve(Buffer.concat(this.chunks).toString());
            };
            switch (res.headers['content-encoding']) {
                case 'gzip':
                    (0, stream_1.pipeline)(res, zlib.createGunzip(), this.memoryStream, pipelineCallback);
                    break;
                default:
                    (0, stream_1.pipeline)(res, this.memoryStream, pipelineCallback);
                    break;
            }
        });
    }
    async _wrappedWait() {
        this.listened = true;
        if (this.rejection) {
            throw this.rejection;
        }
        return this.promise;
    }
    text() {
        return this._wrappedWait();
    }
    async json() {
        const stringValue = await this._wrappedWait();
        return JSON.parse(stringValue);
    }
}
exports.default = NodeResponse;
//# sourceMappingURL=NodeResponse.js.map