"use strict";

exports.__esModule = true;
exports.getInstrumentationFlags = getInstrumentationFlags;

var _constants = require("./constants");

function getInstrumentationFlags(instrument, disabledInstrumentations) {
  var _flags;

  var flags = (_flags = {}, _flags[_constants.XMLHTTPREQUEST] = false, _flags[_constants.FETCH] = false, _flags[_constants.HISTORY] = false, _flags[_constants.PAGE_LOAD] = false, _flags[_constants.ERROR] = false, _flags[_constants.EVENT_TARGET] = false, _flags[_constants.CLICK] = false, _flags);

  if (!instrument) {
    return flags;
  }

  Object.keys(flags).forEach(function (key) {
    if (disabledInstrumentations.indexOf(key) === -1) {
      flags[key] = true;
    }
  });
  return flags;
}