"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Badge = exports.BADGE_BORDER = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importDefault(require("react"));
const color_calcs_1 = require("../../../../common/color_calcs");
const color_library_wrappers_1 = require("../../../../common/color_library_wrappers");
exports.BADGE_BORDER = 1;
const ICON_MARGIN = 4;
const Badge = ({ className, value, backgroundColor, borderColor, icon, iconPosition = 'after', }) => {
    const classes = (0, classnames_1.default)('echBadge__content', className);
    const color = (0, color_calcs_1.highContrastColor)((0, color_library_wrappers_1.colorToRgba)(backgroundColor)).color.keyword;
    const iconStyles = value !== ''
        ? {
            [iconPosition === 'before' ? 'marginInlineEnd' : 'marginInlineStart']: icon ? ICON_MARGIN : undefined,
        }
        : undefined;
    const optionalIcon = icon ? react_1.default.createElement("span", { style: iconStyles }, icon) : null;
    return (react_1.default.createElement("span", { className: classes, style: { backgroundColor, borderColor, color } },
        iconPosition === 'before' && optionalIcon,
        react_1.default.createElement("span", { className: "echBadge__text" }, value),
        iconPosition === 'after' && optionalIcon));
};
exports.Badge = Badge;
//# sourceMappingURL=badge.js.map