"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapping = mapping;
exports.doing = doing;
exports.filtering = filtering;
exports.map = map;
exports.filter = filter;
exports.executing = executing;
exports.pipeline = pipeline;
function mapping(fun) {
    return function* (iterable) {
        for (const next of iterable)
            yield fun(next);
    };
}
function doing(fun) {
    return function* (iterable) {
        for (const next of iterable)
            fun(next);
    };
}
function filtering(fun) {
    return function* (iterable) {
        for (const next of iterable) {
            if (fun(next))
                yield next;
        }
    };
}
function map(iterable, fun) {
    return mapping(fun)(iterable);
}
function filter(iterable, fun) {
    return filtering(fun)(iterable);
}
function executing(iterable) {
    const iterator = iterable[Symbol.iterator]();
    while (!iterator.next().done) { }
}
function pipeline(arg, ...functions) {
    return functions.reduce((iterator, fun) => fun(iterator), arg);
}
//# sourceMappingURL=iterables.js.map