"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLinearNonDenserTicks = getLinearNonDenserTicks;
const get_linear_ticks_1 = require("../chart_types/xy_chart/utils/get_linear_ticks");
function getLinearNonDenserTicks(start, stop, count, base, minInterval) {
    let currentCount = count;
    let ticks = (0, get_linear_ticks_1.getLinearTicks)(start, stop, count, base);
    while (ticks.length > 2 && currentCount > 0 && (ticks[1] ?? NaN) - (ticks[0] ?? NaN) < minInterval) {
        currentCount--;
        ticks = (0, get_linear_ticks_1.getLinearTicks)(start, stop, currentCount, base);
    }
    return ticks;
}
//# sourceMappingURL=utils.js.map