"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCopy = void 0;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _inner_text = require("../inner_text");
var _copy = require("../copy");
var _i18n = require("../i18n");
var _button = require("../button");
var _utils = require("./utils");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /**
 * Hook that returns copy-related state/logic/utils
 */
var useCopy = exports.useCopy = function useCopy(_ref) {
  var copyAriaLabel = _ref.copyAriaLabel,
    isCopyable = _ref.isCopyable,
    isVirtualized = _ref.isVirtualized,
    children = _ref.children;
  var _useInnerText = (0, _inner_text.useInnerText)(''),
    _useInnerText2 = _slicedToArray(_useInnerText, 2),
    innerTextRef = _useInnerText2[0],
    _innerText = _useInnerText2[1];
  var innerText = (0, _react.useMemo)(function () {
    var _innerText$replace;
    if (!_innerText) return;
    return (_innerText
    // remove text that should not be copied (e.g. screen reader instructions)
    === null || _innerText
    // remove text that should not be copied (e.g. screen reader instructions)
    === void 0 || (_innerText$replace = _innerText
    // remove text that should not be copied (e.g. screen reader instructions)
    .replace(_services.noCopyBoundsRegex, '')
    // Normalize line terminations to match native JS format
    ) === null || _innerText$replace === void 0 || (_innerText$replace = _innerText$replace.replace(_utils.NEW_LINE_REGEX_GLOBAL, '\n')
    // remove initial line break (if there was hidden content removed)
    ) === null || _innerText$replace === void 0 || (_innerText$replace = _innerText$replace.replace(/^\n/, '')
    // Reduce two or more consecutive new line characters to a single one
    // This is needed primarily because of how syntax highlighting
    // generated DOM elements affect `innerText` output.
    ) === null || _innerText$replace === void 0 ? void 0 : _innerText$replace.replace(/\n{2,}/g, '\n')) || '';
  }, [_innerText]);
  var textToCopy = isVirtualized ? "".concat(children) : innerText; // Virtualized code blocks do not have inner text

  var showCopyButton = isCopyable && textToCopy;
  var copyDefaultAriaLabel = (0, _i18n.useEuiI18n)('euiCodeBlockCopy.copy', 'Copy');
  var copyButton = (0, _react.useMemo)(function () {
    return showCopyButton ? (0, _react2.jsx)("div", {
      className: "euiCodeBlock__copyButton"
    }, (0, _react2.jsx)(_copy.EuiCopy, {
      textToCopy: textToCopy
    }, function (copy) {
      return (0, _react2.jsx)(_button.EuiButtonIcon, {
        onClick: copy,
        iconType: "copyClipboard",
        color: "text",
        "aria-label": copyAriaLabel || copyDefaultAriaLabel,
        "data-test-subj": "euiCodeBlockCopy"
      });
    })) : null;
  }, [copyAriaLabel, copyDefaultAriaLabel, showCopyButton, textToCopy]);
  return {
    innerTextRef: innerTextRef,
    copyButton: copyButton
  };
};