"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDatePopoverButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../../services");
var _i18n = require("../../../i18n");
var _popover = require("../../../popover");
var _pretty_duration = require("../pretty_duration");
var _date_popover_content = require("./date_popover_content");
var _date_popover_button = require("./date_popover_button.styles");
var _react2 = require("@emotion/react");
var _excluded = ["position", "isDisabled", "isInvalid", "needsUpdating", "value", "buttonProps", "canRoundRelativeUnits", "roundUp", "onChange", "locale", "dateFormat", "utcOffset", "minDate", "maxDate", "timeFormat", "isOpen", "onPopoverToggle", "onPopoverClose", "compressed", "timeOptions"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// eslint-disable-line import/named
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiDatePopoverButton = exports.EuiDatePopoverButton = function EuiDatePopoverButton(props) {
  var position = props.position,
    isDisabled = props.isDisabled,
    isInvalid = props.isInvalid,
    needsUpdating = props.needsUpdating,
    value = props.value,
    buttonProps = props.buttonProps,
    canRoundRelativeUnits = props.canRoundRelativeUnits,
    roundUp = props.roundUp,
    onChange = props.onChange,
    locale = props.locale,
    dateFormat = props.dateFormat,
    utcOffset = props.utcOffset,
    minDate = props.minDate,
    maxDate = props.maxDate,
    timeFormat = props.timeFormat,
    isOpen = props.isOpen,
    onPopoverToggle = props.onPopoverToggle,
    onPopoverClose = props.onPopoverClose,
    compressed = props.compressed,
    timeOptions = props.timeOptions,
    rest = _objectWithoutProperties(props, _excluded);
  var classes = (0, _classnames.default)(['euiDatePopoverButton', "euiDatePopoverButton--".concat(position), {
    'euiDatePopoverButton--compressed': compressed,
    'euiDatePopoverButton-isSelected': isOpen,
    'euiDatePopoverButton-isInvalid': isInvalid,
    'euiDatePopoverButton-needsUpdating': needsUpdating,
    'euiDatePopoverButton-disabled': isDisabled
  }]);
  var styles = (0, _services.useEuiMemoizedStyles)(_date_popover_button.euiDatePopoverButtonStyles);
  var cssStyles = [styles.euiDatePopoverButton, buttonProps === null || buttonProps === void 0 ? void 0 : buttonProps.css];
  var formattedValue = (0, _pretty_duration.useFormatTimeString)(value, dateFormat, {
    roundUp: roundUp,
    locale: locale,
    canRoundRelativeUnits: canRoundRelativeUnits
  });
  var title = formattedValue;
  var invalidTitle = (0, _i18n.useEuiI18n)('euiDatePopoverButton.invalidTitle', 'Invalid date: {title}', {
    title: title
  });
  var outdatedTitle = (0, _i18n.useEuiI18n)('euiDatePopoverButton.outdatedTitle', 'Update needed: {title}', {
    title: title
  });
  if (isInvalid) {
    title = invalidTitle;
  } else if (needsUpdating) {
    title = outdatedTitle;
  }
  var button = (0, _react2.jsx)("button", _extends({
    type: "button",
    onClick: onPopoverToggle,
    className: classes,
    title: title,
    disabled: isDisabled,
    "data-test-subj": "superDatePicker".concat(position, "DatePopoverButton")
  }, buttonProps, {
    css: cssStyles
  }), formattedValue);
  return (0, _react2.jsx)(_popover.EuiPopover, _extends({
    button: button,
    isOpen: isOpen,
    closePopover: onPopoverClose,
    anchorPosition: position === 'start' ? 'downLeft' : 'downRight',
    display: "block",
    panelPaddingSize: "none"
  }, rest, {
    css: value === 'now' && styles.now
  }), (0, _react2.jsx)(_date_popover_content.EuiDatePopoverContent, {
    value: value,
    roundUp: roundUp,
    canRoundRelativeUnits: canRoundRelativeUnits,
    onChange: onChange,
    dateFormat: dateFormat,
    timeFormat: timeFormat,
    locale: locale,
    position: position,
    utcOffset: utcOffset,
    timeOptions: timeOptions,
    minDate: minDate,
    maxDate: maxDate
  }));
};
EuiDatePopoverButton.propTypes = {
  className: _propTypes.default.string,
  buttonProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  dateFormat: _propTypes.default.string.isRequired,
  isDisabled: _propTypes.default.bool,
  isInvalid: _propTypes.default.bool,
  isOpen: _propTypes.default.bool.isRequired,
  needsUpdating: _propTypes.default.bool,
  locale: _propTypes.default.any,
  onChange: _propTypes.default.func.isRequired,
  onPopoverClose: _propTypes.default.any.isRequired,
  onPopoverToggle: _propTypes.default.func.isRequired,
  position: _propTypes.default.oneOf(["start", "end"]).isRequired,
  canRoundRelativeUnits: _propTypes.default.bool,
  roundUp: _propTypes.default.bool,
  timeFormat: _propTypes.default.string.isRequired,
  value: _propTypes.default.string.isRequired,
  utcOffset: _propTypes.default.number,
  minDate: _propTypes.default.any,
  maxDate: _propTypes.default.any,
  compressed: _propTypes.default.bool,
  timeOptions: _propTypes.default.shape({
    timeTenseOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    timeUnitsOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    relativeOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
      text: _propTypes.default.string.isRequired,
      value: _propTypes.default.oneOfType([_propTypes.default.oneOf(["s", "m", "h", "d", "w", "M", "y"]).isRequired, _propTypes.default.oneOf(["s+", "m+", "h+", "d+", "w+", "M+", "y+"]).isRequired]).isRequired
    }).isRequired).isRequired,
    relativeRoundingLabels: _propTypes.default.any.isRequired,
    refreshUnitsOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    commonDurationRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
      end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
      label: _propTypes.default.string,
      start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
    }).isRequired).isRequired
  }).isRequired
};
EuiDatePopoverButton.displayName = 'EuiDatePopoverButton';