"use strict";

var _react = _interopRequireDefault(require("react"));
var _button = require("../button");
var _error_boundary = require("./error_boundary");
var _spacer = require("../spacer");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var handleFocus = function handleFocus() {
  var target = document.querySelector('pre.euiCodeBlock__pre');
  target.focus();
};
describe('EuiErrorBoundary', function () {
  describe('Automated accessibility check when an error is thrown', function () {
    var BadComponent = function BadComponent() {
      throw new Error('Throw the error.');
    };
    beforeEach(function () {
      cy.on('uncaught:exception', function (err) {
        if (err.message.includes('Throw the error')) {
          return false;
        }
      });
      cy.viewport(1024, 768); // medium breakpoint
      cy.realMount((0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_button.EuiButton, {
        color: "primary",
        onClick: handleFocus,
        "data-test-subj": "cy-error-boundary-button"
      }, "Press to focus"), (0, _react2.jsx)(_spacer.EuiSpacer, null), (0, _react2.jsx)(_error_boundary.EuiErrorBoundary, null, (0, _react2.jsx)(BadComponent, null))));
    });
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations and accepts focus when the button is pressed', function () {
      cy.get('button').first().focus();
      cy.realPress('Enter');
      cy.get('pre.euiCodeBlock__pre').should('have.focus');
      cy.checkAxe();
    });
  });
  describe('Automated accessibility check when no error is thrown', function () {
    var GoodComponent = function GoodComponent() {
      return (0, _react2.jsx)("div", {
        "data-test-subj": "cy-good-component"
      }, "This is a properly rendered component.");
    };
    beforeEach(function () {
      cy.viewport(1024, 768); // medium breakpoint
      cy.realMount((0, _react2.jsx)(_error_boundary.EuiErrorBoundary, null, (0, _react2.jsx)(GoodComponent, null)));
    });
    it('has zero violations when no violations are thrown', function () {
      cy.get('div[data-test-subj="cy-good-component"]').should('exist');
      cy.checkAxe();
    });
  });
});