"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTableCellContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _predicate = require("../../services/predicate");
var _text_truncate = require("../text_truncate");
var _responsive_context = require("./mobile/responsive_context");
var _table_cell_content = require("./_table_cell_content.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "align", "textOnly", "truncateText", "hasActions"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiTableCellContent = exports.EuiTableCellContent = function EuiTableCellContent(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$align = _ref.align,
    align = _ref$align === void 0 ? _services.LEFT_ALIGNMENT : _ref$align,
    textOnly = _ref.textOnly,
    _ref$truncateText = _ref.truncateText,
    truncateText = _ref$truncateText === void 0 ? false : _ref$truncateText,
    hasActions = _ref.hasActions,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isResponsive = (0, _responsive_context.useEuiTableIsResponsive)();
  var styles = (0, _services.useEuiMemoizedStyles)(_table_cell_content.euiTableCellContentStyles);
  var cssStyles = [styles.euiTableCellContent, styles[align], truncateText === true && styles.truncateText, truncateText === false && styles.wrapText].concat(_toConsumableArray(hasActions ? [styles.hasActions.actions, !isResponsive && styles.hasActions.desktop, isResponsive && hasActions !== 'custom' && styles.hasActions.mobile] : []));
  var classes = (0, _classnames.default)('euiTableCellContent', className);
  var renderedChildren = (0, _react.useMemo)(function () {
    var textClasses = 'euiTableCellContent__text';
    if ((0, _predicate.isObject)(truncateText) && truncateText.lines) {
      return (0, _react2.jsx)(_text_truncate.EuiTextBlockTruncate, {
        lines: truncateText.lines,
        cloneElement: true
      }, (0, _react2.jsx)("span", {
        className: textClasses
      }, children));
    }
    if (textOnly === true || truncateText === true) {
      return (0, _react2.jsx)("span", {
        className: textClasses
      }, children);
    }
    return children;
  }, [children, textOnly, truncateText]);
  return (0, _react2.jsx)("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), renderedChildren);
};
EuiTableCellContent.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  truncateText: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    lines: _propTypes.default.number.isRequired
  }).isRequired]).isRequired, _propTypes.default.oneOf([null])])
};