"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTableFooterCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _utils = require("./utils");
var _table_cell_content = require("./_table_cell_content");
var _table_cells_shared = require("./table_cells_shared.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "align", "className", "width", "style"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiTableFooterCell = exports.EuiTableFooterCell = function EuiTableFooterCell(_ref) {
  var children = _ref.children,
    _ref$align = _ref.align,
    align = _ref$align === void 0 ? _services.LEFT_ALIGNMENT : _ref$align,
    className = _ref.className,
    width = _ref.width,
    style = _ref.style,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiTableFooterCell', className);
  var inlineStyles = (0, _utils.resolveWidthAsStyle)(style, width);
  var styles = (0, _services.useEuiMemoizedStyles)(_table_cells_shared.euiTableHeaderFooterCellStyles);
  return (0, _react2.jsx)("td", _extends({
    css: styles.euiTableFooterCell,
    className: classes,
    style: inlineStyles
  }, rest), (0, _react2.jsx)(_table_cell_content.EuiTableCellContent, {
    align: align,
    truncateText: true,
    textOnly: true
  }, children));
};
EuiTableFooterCell.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  align: _propTypes.default.any,
  width: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired])
};