"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiEmotionThemeProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _hooks = require("./hooks");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * @see https://emotion.sh/docs/theming
 * This Emotion theme provider is added for *consumer usage* & convenience only.
 *
 * EUI should stick to using our own context/`useEuiTheme` internally
 * instead of Emotion's shorthand `css={theme => {}}` API. If consumers
 * set their own theme via <ThemeProvider>; EUI's styles should continue
 * working as-is.
 */
var EuiEmotionThemeProvider = exports.EuiEmotionThemeProvider = function EuiEmotionThemeProvider(_ref) {
  var children = _ref.children;
  var euiThemeContext = (0, _hooks.useEuiTheme)();
  return (0, _react2.jsx)(_react2.ThemeProvider, {
    theme: euiThemeContext
  }, children);
};