"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cloneConstantValueBinding = cloneConstantValueBinding;
const cloneBindingCache_1 = require("./cloneBindingCache");
/**
 * Clones a ConstantValueBinding
 */
function cloneConstantValueBinding(binding) {
    return {
        cache: (0, cloneBindingCache_1.cloneBindingCache)(binding.cache),
        id: binding.id,
        isSatisfiedBy: binding.isSatisfiedBy,
        moduleId: binding.moduleId,
        onActivation: binding.onActivation,
        onDeactivation: binding.onDeactivation,
        scope: binding.scope,
        serviceIdentifier: binding.serviceIdentifier,
        type: binding.type,
        // The value is not cloned as it's a resolved value
        value: binding.value,
    };
}
//# sourceMappingURL=cloneConstantValueBinding.js.map