"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.injectFromBase = injectFromBase;
const prototype_utils_1 = require("@inversifyjs/prototype-utils");
const InversifyCoreError_1 = require("../../error/models/InversifyCoreError");
const InversifyCoreErrorKind_1 = require("../../error/models/InversifyCoreErrorKind");
const injectFrom_1 = require("./injectFrom");
function injectFromBase(options) {
    // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
    return (target) => {
        const baseType = (0, prototype_utils_1.getBaseType)(target);
        if (baseType === undefined) {
            throw new InversifyCoreError_1.InversifyCoreError(InversifyCoreErrorKind_1.InversifyCoreErrorKind.injectionDecoratorConflict, `Expected base type for type "${target.name}", none found.`);
        }
        (0, injectFrom_1.injectFrom)({
            ...options,
            type: baseType,
        })(target);
    };
}
//# sourceMappingURL=injectFromBase.js.map