"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBasicAuthHeader = exports.combineHeadersWithBasicAuthHeader = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBasicAuthHeader = ({
  username,
  password
}) => {
  const header = `Basic ${Buffer.from(`${username}:${password}`).toString('base64')}`;
  return {
    Authorization: header
  };
};
exports.getBasicAuthHeader = getBasicAuthHeader;
const combineHeadersWithBasicAuthHeader = ({
  username,
  password,
  headers
} = {}) => {
  return username != null && password != null ? {
    ...getBasicAuthHeader({
      username,
      password
    }),
    ...headers
  } : headers !== null && headers !== void 0 ? headers : undefined;
};
exports.combineHeadersWithBasicAuthHeader = combineHeadersWithBasicAuthHeader;